/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.standalone;

import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.standalone.Configuration;
import io.smallrye.faulttolerance.standalone.DefaultConfiguration;
import io.smallrye.faulttolerance.standalone.LazyDependencies;
import io.smallrye.faulttolerance.standalone.TimerAccess;
import io.smallrye.faulttolerance.standalone.TimerAccessImpl;

public final class StandaloneFaultTolerance {
    private static Configuration configuration;
    private static LazyDependencies lazyDependencies;

    public static synchronized void configure(Configuration configuration) {
        if (StandaloneFaultTolerance.configuration != null) {
            throw new IllegalStateException("Configuration has already been finalized, cannot reconfigure");
        }
        Preconditions.checkNotNull((Object)configuration, (String)"Configuration must be set");
        StandaloneFaultTolerance.configuration = configuration;
    }

    @Deprecated(forRemoval=true)
    public static synchronized TimerAccess timerAccess() {
        return new TimerAccessImpl(StandaloneFaultTolerance.getLazyDependencies().timer());
    }

    public static synchronized void shutdown() throws InterruptedException {
        InterruptedException interrupted = null;
        try {
            StandaloneFaultTolerance.getLazyDependencies().shutdown();
        }
        catch (InterruptedException e) {
            interrupted = e;
        }
        try {
            StandaloneFaultTolerance.getConfiguration().onShutdown();
        }
        catch (InterruptedException e) {
            interrupted = e;
        }
        if (interrupted != null) {
            throw interrupted;
        }
    }

    static synchronized Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new DefaultConfiguration();
        }
        return configuration;
    }

    static synchronized LazyDependencies getLazyDependencies() {
        if (lazyDependencies == null) {
            lazyDependencies = new LazyDependencies(StandaloneFaultTolerance.getConfiguration());
        }
        return lazyDependencies;
    }
}

