/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.standalone;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsProvider;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import io.smallrye.faulttolerance.core.metrics.OpenTelemetryRecorder;
import io.smallrye.faulttolerance.core.timer.Timer;
import io.smallrye.faulttolerance.standalone.MetricsAdapter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class OpenTelemetryAdapter
implements MetricsAdapter {
    private final Meter meter;

    public OpenTelemetryAdapter(Meter meter) {
        this.meter = meter;
    }

    MetricsProvider createMetricsProvider(Timer timer) {
        Attributes attributes = Attributes.of((AttributeKey)AttributeKey.stringKey((String)"id"), (Object)("" + timer.getId()));
        this.meter.upDownCounterBuilder("ft.timer.scheduled").buildWithCallback(m -> m.record((long)timer.countScheduledTasks(), attributes));
        return new MetricsProvider(){
            private final Map<Object, MetricsRecorder> cache = new ConcurrentHashMap<Object, MetricsRecorder>();

            public boolean isEnabled() {
                return true;
            }

            public MetricsRecorder create(MeteredOperation operation) {
                return this.cache.computeIfAbsent(operation.cacheKey(), ignored -> new OpenTelemetryRecorder(OpenTelemetryAdapter.this.meter, operation));
            }
        };
    }
}

