/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.bulkhead;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.FutureCancellationEvent;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadEvents;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadLogger;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class SemaphoreThreadPoolBulkhead<V>
extends BulkheadBase<V> {
    private final int queueSize;
    private final Semaphore capacitySemaphore;
    private final Semaphore workSemaphore;

    public SemaphoreThreadPoolBulkhead(FaultToleranceStrategy<V> delegate, String description, int size, int queueSize) {
        super(description, delegate);
        this.queueSize = queueSize;
        this.capacitySemaphore = new Semaphore(size + queueSize, true);
        this.workSemaphore = new Semaphore(size, true);
    }

    @Override
    public V apply(InvocationContext<V> ctx) throws Exception {
        BulkheadLogger.LOG.trace("ThreadPoolBulkhead started");
        try {
            V v = this.doApply(ctx);
            return v;
        }
        finally {
            BulkheadLogger.LOG.trace("ThreadPoolBulkhead finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V doApply(InvocationContext<V> ctx) throws Exception {
        if (this.capacitySemaphore.tryAcquire()) {
            BulkheadLogger.LOG.trace("Capacity semaphore acquired, accepting task into bulkhead");
            ctx.fireEvent(BulkheadEvents.DecisionMade.ACCEPTED);
            ctx.fireEvent(BulkheadEvents.StartedWaiting.INSTANCE);
            AtomicBoolean cancellationInvalid = new AtomicBoolean(false);
            AtomicBoolean cancelled = new AtomicBoolean(false);
            AtomicReference<Thread> executingThread = new AtomicReference<Thread>(Thread.currentThread());
            ctx.registerEventHandler(FutureCancellationEvent.class, event -> {
                if (cancellationInvalid.get()) {
                    return;
                }
                if (BulkheadLogger.LOG.isTraceEnabled()) {
                    BulkheadLogger.LOG.tracef("Cancelling bulkhead task,%s interrupting executing thread", event.interruptible ? "" : " NOT");
                }
                cancelled.set(true);
                if (event.interruptible) {
                    ((Thread)executingThread.get()).interrupt();
                }
            });
            try {
                this.workSemaphore.acquire();
                BulkheadLogger.LOG.trace("Work semaphore acquired, running task");
            }
            catch (InterruptedException e) {
                cancellationInvalid.set(true);
                this.capacitySemaphore.release();
                BulkheadLogger.LOG.trace("Capacity semaphore released, task leaving bulkhead");
                ctx.fireEvent(BulkheadEvents.FinishedWaiting.INSTANCE);
                throw new CancellationException();
            }
            ctx.fireEvent(BulkheadEvents.FinishedWaiting.INSTANCE);
            ctx.fireEvent(BulkheadEvents.StartedRunning.INSTANCE);
            try {
                if (cancelled.get()) {
                    throw new CancellationException();
                }
                V v = this.delegate.apply(ctx);
                return v;
            }
            finally {
                cancellationInvalid.set(true);
                this.workSemaphore.release();
                BulkheadLogger.LOG.trace("Work semaphore released, task finished");
                this.capacitySemaphore.release();
                BulkheadLogger.LOG.trace("Capacity semaphore released, task leaving bulkhead");
                ctx.fireEvent(BulkheadEvents.FinishedRunning.INSTANCE);
            }
        }
        BulkheadLogger.LOG.debugOrTrace(this.description + " invocation prevented by bulkhead", "Capacity semaphore not acquired, rejecting task from bulkhead");
        ctx.fireEvent(BulkheadEvents.DecisionMade.REJECTED);
        throw this.bulkheadRejected();
    }

    int getQueueSize() {
        return Math.max(0, this.queueSize - this.capacitySemaphore.availablePermits());
    }
}

