/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.invocation;

import io.smallrye.faulttolerance.core.invocation.Invoker;
import io.smallrye.faulttolerance.core.util.Preconditions;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.function.Function;

public class SpecialMethodInvoker<V>
implements Invoker<V> {
    private final MethodHandle methodHandle;
    private final Object target;
    private final Object[] arguments;

    public SpecialMethodInvoker(Method method, Object target, Object[] arguments) throws ReflectiveOperationException {
        Preconditions.checkNotNull(arguments, "Arguments array must be set");
        Preconditions.check(arguments.length, arguments.length == method.getParameterCount(), "Argument array length must be " + method.getParameterCount());
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        Class<?> declaringClass = method.getDeclaringClass();
        this.methodHandle = MethodHandles.privateLookupIn(declaringClass, MethodHandles.lookup()).findSpecial(declaringClass, method.getName(), methodType, declaringClass);
        this.target = target;
        this.arguments = arguments;
    }

    @Override
    public int parametersCount() {
        return this.arguments.length;
    }

    @Override
    public <T> T getArgument(int index, Class<T> parameterType) {
        return parameterType.cast(this.arguments[index]);
    }

    @Override
    public <T> T replaceArgument(int index, Class<T> parameterType, Function<T, T> transformation) {
        T oldArg = parameterType.cast(this.arguments[index]);
        T newArg = transformation.apply(oldArg);
        this.arguments[index] = newArg;
        return oldArg;
    }

    @Override
    public V proceed() {
        try {
            return (V)this.methodHandle.bindTo(this.target).invokeWithArguments(this.arguments);
        }
        catch (Throwable e) {
            throw SneakyThrow.sneakyThrow(e);
        }
    }
}

