/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class SmallRyeConfig
implements Config,
Serializable {
    static final Comparator<ConfigSource> CONFIG_SOURCE_COMPARATOR = new Comparator<ConfigSource>(){

        @Override
        public int compare(ConfigSource o1, ConfigSource o2) {
            int res = Integer.signum(o2.getOrdinal() - o1.getOrdinal());
            return res != 0 ? res : o2.getName().compareTo(o1.getName());
        }
    };
    private final AtomicReference<List<ConfigSource>> configSourcesRef;
    private final Map<Type, Converter<?>> converters;

    protected SmallRyeConfig(List<ConfigSource> configSources, Map<Type, Converter<?>> converters) {
        this.configSourcesRef = new AtomicReference<List<ConfigSource>>(Collections.unmodifiableList(configSources));
        this.converters = new HashMap(Converters.ALL_CONVERTERS);
        this.converters.putAll(converters);
    }

    public <T, C extends Collection<T>> C getValues(String name, Class<T> itemClass, IntFunction<C> collectionFactory) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            String[] itemStrings = StringUtil.split(value);
            Collection collection = (Collection)collectionFactory.apply(itemStrings.length);
            for (String itemString : itemStrings) {
                collection.add(this.convert(itemString, itemClass));
            }
            return (C)collection;
        }
        return (C)((Collection)collectionFactory.apply(0));
    }

    public <T> T getValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            if (value.isEmpty()) break;
            return this.convert(value, aClass);
        }
        if (aClass.isAssignableFrom(OptionalInt.class)) {
            return aClass.cast(OptionalInt.empty());
        }
        if (aClass.isAssignableFrom(OptionalLong.class)) {
            return aClass.cast(OptionalLong.empty());
        }
        if (aClass.isAssignableFrom(OptionalDouble.class)) {
            return aClass.cast(OptionalDouble.empty());
        }
        throw new NoSuchElementException("Property " + name + " not found");
    }

    public <T> Optional<T> getOptionalValue(String name, Class<T> aClass) {
        for (ConfigSource configSource : this.getConfigSources()) {
            String value = configSource.getValue(name);
            if (value == null) continue;
            return value.isEmpty() ? Optional.empty() : Optional.of(this.convert(value, aClass));
        }
        return Optional.empty();
    }

    public Iterable<String> getPropertyNames() {
        HashSet<String> names = new HashSet<String>();
        for (ConfigSource configSource : this.getConfigSources()) {
            names.addAll(configSource.getProperties().keySet());
        }
        return names;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.configSourcesRef.get();
    }

    public void addConfigSource(ConfigSource configSource) {
        List<ConfigSource> newVal;
        List<ConfigSource> oldVal;
        do {
            oldVal = this.configSourcesRef.get();
            int oldSize = oldVal.size();
            newVal = Arrays.asList(oldVal.toArray(new ConfigSource[oldSize + 1]));
            newVal.set(oldSize, configSource);
            newVal.sort(CONFIG_SOURCE_COMPARATOR);
        } while (!this.configSourcesRef.compareAndSet(oldVal, Collections.unmodifiableList(newVal)));
    }

    public <T> T convert(String value, Class<T> asType) {
        if (value != null) {
            boolean isArray = asType.isArray();
            if (isArray) {
                String[] split = StringUtil.split(value);
                Class<?> componentType = asType.getComponentType();
                T array = asType.cast(Array.newInstance(componentType, split.length));
                for (int i = 0; i < split.length; ++i) {
                    Array.set(array, i, this.convert(split[i], componentType));
                }
                return array;
            }
            Converter<T> converter = this.getConverter(asType);
            return (T)converter.convert(value);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Converter<T> getConverter(Class<T> asType) {
        Object converter = this.converters.get(asType);
        if (converter == null) {
            Map<Type, Converter<?>> map = this.converters;
            synchronized (map) {
                converter = ImplicitConverters.getConverter(asType);
                this.converters.putIfAbsent(asType, (Converter<?>)converter);
            }
        }
        if (converter == null) {
            throw new IllegalArgumentException("No Converter registered for class " + asType);
        }
        return converter;
    }
}

