/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.extension;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.reactive.messaging.MutinyEmitter;
import io.smallrye.reactive.messaging.providers.extension.AbstractEmitter;
import io.smallrye.reactive.messaging.providers.extension.EmitterConfiguration;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.util.concurrent.CompletableFuture;
import org.eclipse.microprofile.reactive.messaging.Message;

public class MutinyEmitterImpl<T>
extends AbstractEmitter<T>
implements MutinyEmitter<T> {
    public MutinyEmitterImpl(EmitterConfiguration config, long defaultBufferSize) {
        super(config, defaultBufferSize);
    }

    @CheckReturnValue
    public Uni<Void> send(T payload) {
        if (payload == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        Context context = Vertx.currentContext();
        Uni uni = Uni.createFrom().emitter(e -> this.emit(ContextAwareMessage.of(payload).withAck(() -> {
            e.complete(null);
            return CompletableFuture.completedFuture(null);
        }).withNack(reason -> {
            e.fail(reason);
            return CompletableFuture.completedFuture(null);
        })));
        if (context != null) {
            uni = uni.emitOn(runnable -> context.runOnContext(x -> runnable.run()));
        }
        return uni;
    }

    public void sendAndAwait(T payload) {
        this.send(payload).await().indefinitely();
    }

    public Cancellable sendAndForget(T payload) {
        return this.send(payload).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }

    public <M extends Message<? extends T>> void send(M msg) {
        if (msg == null) {
            throw ProviderExceptions.ex.illegalArgumentForNullValue();
        }
        Uni.createFrom().emitter(e -> {
            try {
                this.emit(msg);
            }
            catch (Exception t) {
                msg.nack((Throwable)t);
                throw t;
            }
        }).subscribe().with(x -> {}, ProviderLogging.log::failureEmittingMessage);
    }
}

