/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.tracing;

import io.opentelemetry.context.propagation.TextMapGetter;
import io.smallrye.reactive.messaging.kafka.tracing.KafkaTrace;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public enum KafkaTraceTextMapGetter implements TextMapGetter<KafkaTrace>
{
    INSTANCE;


    public Iterable<String> keys(KafkaTrace carrier) {
        ArrayList<String> keys = new ArrayList<String>();
        Headers headers = carrier.getHeaders();
        for (Header header : headers) {
            keys.add(header.key());
        }
        return keys;
    }

    public String get(KafkaTrace carrier, String key) {
        byte[] value;
        Header header;
        if (carrier != null && (header = carrier.getHeaders().lastHeader(key)) != null && (value = header.value()) != null) {
            return new String(value, StandardCharsets.UTF_8);
        }
        return null;
    }
}

