/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.reply;

import io.opentelemetry.api.OpenTelemetry;
import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.EmitterConfiguration;
import io.smallrye.reactive.messaging.EmitterFactory;
import io.smallrye.reactive.messaging.MessageConverter;
import io.smallrye.reactive.messaging.annotations.EmitterFactoryFor;
import io.smallrye.reactive.messaging.kafka.DeserializationFailureHandler;
import io.smallrye.reactive.messaging.kafka.KafkaCDIEvents;
import io.smallrye.reactive.messaging.kafka.KafkaConsumerRebalanceListener;
import io.smallrye.reactive.messaging.kafka.commit.KafkaCommitHandler;
import io.smallrye.reactive.messaging.kafka.fault.KafkaFailureHandler;
import io.smallrye.reactive.messaging.kafka.reply.CorrelationIdHandler;
import io.smallrye.reactive.messaging.kafka.reply.KafkaRequestReply;
import io.smallrye.reactive.messaging.kafka.reply.KafkaRequestReplyImpl;
import io.smallrye.reactive.messaging.kafka.reply.ReplyFailureHandler;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.smallrye.reactive.messaging.providers.extension.ChannelProducer;
import io.smallrye.reactive.messaging.providers.helpers.ConverterUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Channel;

@EmitterFactoryFor(value=KafkaRequestReply.class)
@ApplicationScoped
public class KafkaRequestReplyFactory
implements EmitterFactory<KafkaRequestReplyImpl<Object, Object>> {
    @Inject
    ChannelRegistry channelRegistry;
    @Inject
    ExecutionHolder holder;
    @Inject
    KafkaCDIEvents kafkaCDIEvents;
    @Inject
    Instance<MessageConverter> converters;
    @Inject
    @Any
    Instance<DeserializationFailureHandler<?>> failureHandlers;
    @Inject
    @Any
    Instance<KafkaCommitHandler.Factory> commitStrategyFactories;
    @Inject
    @Any
    Instance<KafkaFailureHandler.Factory> failureStrategyFactories;
    @Inject
    @Any
    Instance<KafkaConsumerRebalanceListener> rebalanceListeners;
    @Inject
    @Any
    Instance<CorrelationIdHandler> correlationIdHandlers;
    @Inject
    @Any
    Instance<ReplyFailureHandler> replyFailureHandlers;
    @Inject
    Instance<Config> config;
    @Inject
    @Any
    Instance<Map<String, Object>> configurations;
    @Inject
    Instance<OpenTelemetry> openTelemetryInstance;

    public KafkaRequestReplyImpl<Object, Object> createEmitter(EmitterConfiguration configuration, long defaultBufferSize) {
        return new KafkaRequestReplyImpl<Object, Object>(configuration, defaultBufferSize, (Config)this.config.get(), this.configurations, this.holder.vertx(), this.kafkaCDIEvents, this.openTelemetryInstance, this.commitStrategyFactories, this.failureStrategyFactories, this.failureHandlers, this.correlationIdHandlers, this.replyFailureHandlers, this.rebalanceListeners);
    }

    @Produces
    @Typed(value={KafkaRequestReply.class})
    @Channel(value="")
    <Req, Rep> KafkaRequestReply<Req, Rep> produceEmitter(InjectionPoint injectionPoint) {
        String channelName = ChannelProducer.getChannelName((InjectionPoint)injectionPoint);
        KafkaRequestReply emitter = (KafkaRequestReply)this.channelRegistry.getEmitter(channelName, KafkaRequestReply.class);
        Type replyType = this.getReplyPayloadType(injectionPoint);
        if (replyType != null) {
            ((KafkaRequestReplyImpl)emitter).setReplyConverter(ConverterUtils.convertFunction(this.converters, (Type)replyType));
        }
        return emitter;
    }

    private Type getReplyPayloadType(InjectionPoint injectionPoint) {
        Type[] typeArguments;
        if (injectionPoint.getType() instanceof ParameterizedType && (typeArguments = ((ParameterizedType)injectionPoint.getType()).getActualTypeArguments()).length == 2) {
            return typeArguments[1];
        }
        return null;
    }
}

