/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.health;

import io.smallrye.reactive.messaging.health.HealthReport;
import io.smallrye.reactive.messaging.kafka.KafkaAdmin;
import io.smallrye.reactive.messaging.kafka.i18n.KafkaLogging;
import java.util.Map;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;

public abstract class BaseHealth {
    public static final String CONNECTION_COUNT_METRIC_NAME = "connection-count";
    protected final String channel;

    public BaseHealth(String channel) {
        this.channel = channel;
    }

    public void close() {
        KafkaAdmin admin = this.getAdmin();
        if (admin != null) {
            try {
                admin.closeAndAwait();
            }
            catch (Throwable e) {
                KafkaLogging.log.exceptionOnClose(e);
            }
        }
    }

    public void isStarted(HealthReport.HealthReportBuilder builder) {
        KafkaAdmin admin = this.getAdmin();
        if (admin != null) {
            this.clientBasedStartupCheck(builder);
        } else {
            this.metricsBasedStartupCheck(builder);
        }
    }

    public void isReady(HealthReport.HealthReportBuilder builder) {
        KafkaAdmin admin = this.getAdmin();
        if (admin != null) {
            this.clientBasedReadinessCheck(builder);
        } else {
            this.metricsBasedReadinessCheck(builder);
        }
    }

    public Metric getMetric(Map<MetricName, ? extends Metric> metrics) {
        Metric metric = null;
        for (MetricName metricName : metrics.keySet()) {
            if (!metricName.name().equals(CONNECTION_COUNT_METRIC_NAME)) continue;
            metric = metrics.get(metricName);
            break;
        }
        return metric;
    }

    protected abstract void metricsBasedStartupCheck(HealthReport.HealthReportBuilder var1);

    protected abstract void metricsBasedReadinessCheck(HealthReport.HealthReportBuilder var1);

    protected abstract void clientBasedStartupCheck(HealthReport.HealthReportBuilder var1);

    protected abstract void clientBasedReadinessCheck(HealthReport.HealthReportBuilder var1);

    public abstract KafkaAdmin getAdmin();
}

