package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Base interface for handlers that perform protocol upgrades.
 *
 * Sub-interfaces hint vert.x core that we should hold the request. This allows later parsing. It can be available
 * during the upgrade, even if there are asynchronous calls in between.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ProtocolUpgradeHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.ProtocolUpgradeHandler.class)
public interface ProtocolUpgradeHandler extends io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.ProtocolUpgradeHandler getDelegate();

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0);

  default public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  ProtocolUpgradeHandler newInstance(io.vertx.ext.web.handler.ProtocolUpgradeHandler arg) {
    return arg != null ? new ProtocolUpgradeHandlerImpl(arg) : null;
  }

}

class ProtocolUpgradeHandlerImpl implements ProtocolUpgradeHandler {
  private final io.vertx.ext.web.handler.ProtocolUpgradeHandler delegate;
  
  @Override
  public io.vertx.ext.web.handler.ProtocolUpgradeHandler getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ProtocolUpgradeHandlerImpl() {
    this.delegate = null;
  }

  public ProtocolUpgradeHandlerImpl(io.vertx.ext.web.handler.ProtocolUpgradeHandler delegate) {
    this.delegate = delegate;
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

}
