package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * An authentication handler that provides API Key support.
 *
 * API keys can be extracted from <code>HTTP headers/query parameters/cookies</code>.
 *
 * By default this handler will extract the API key from an HTTP header named <code>X-API-KEY</code>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.APIKeyHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.APIKeyHandler.class)
public class APIKeyHandler implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<APIKeyHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new APIKeyHandler((io.vertx.ext.web.handler.APIKeyHandler) obj),
    APIKeyHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.APIKeyHandler delegate;
  
  public APIKeyHandler(io.vertx.ext.web.handler.APIKeyHandler delegate) {
    this.delegate = delegate;
  }

  public APIKeyHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.APIKeyHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  APIKeyHandler() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.handler.APIKeyHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    APIKeyHandler that = (APIKeyHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.APIKeyHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.mutiny.ext.web.handler.APIKeyHandler ret = io.vertx.mutiny.ext.web.handler.APIKeyHandler.newInstance((io.vertx.ext.web.handler.APIKeyHandler)io.vertx.ext.web.handler.APIKeyHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param headerName the header name containing the API key
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.APIKeyHandler header(String headerName) { 
    delegate.header(headerName);
    return this;
  }

  /**
   * @param paramName the parameter name containing the API key
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.APIKeyHandler parameter(String paramName) { 
    delegate.parameter(paramName);
    return this;
  }

  /**
   * @param cookieName the cookie name containing the API key
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.APIKeyHandler cookie(String cookieName) { 
    delegate.cookie(cookieName);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  APIKeyHandler newInstance(io.vertx.ext.web.handler.APIKeyHandler arg) {
    return arg != null ? new APIKeyHandler(arg) : null;
  }

}
