package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Content Security Policy (CSP) is an added layer of security that helps to detect and mitigate certain types of
 * attacks, including Cross Site Scripting (XSS) and data injection attacks. These attacks are used for everything from
 * data theft to site defacement to distribution of malware.
 *
 * CSP is designed to be fully backward compatible. Browsers that don't support it still work with servers that
 * implement it, and vice-versa: browsers that don't support CSP simply ignore it, functioning as usual, defaulting to
 * the standard same-origin policy for web content. If the site doesn't offer the CSP header, browsers likewise use the
 * standard same-origin policy.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.CSPHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.CSPHandler.class)
public class CSPHandler implements io.vertx.mutiny.ext.web.handler.SecurityPolicyHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<CSPHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new CSPHandler((io.vertx.ext.web.handler.CSPHandler) obj),
    CSPHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.CSPHandler delegate;
  
  public CSPHandler(io.vertx.ext.web.handler.CSPHandler delegate) {
    this.delegate = delegate;
  }

  public CSPHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.CSPHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  CSPHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.CSPHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CSPHandler that = (CSPHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return a new CSP handler.
   */
  public static io.vertx.mutiny.ext.web.handler.CSPHandler create() { 
    io.vertx.mutiny.ext.web.handler.CSPHandler ret = io.vertx.mutiny.ext.web.handler.CSPHandler.newInstance((io.vertx.ext.web.handler.CSPHandler)io.vertx.ext.web.handler.CSPHandler.create());
    return ret;
  }

  /**
   * @param name the directive name
   * @param value the directive value.
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSPHandler setDirective(String name, String value) { 
    delegate.setDirective(name, value);
    return this;
  }

  /**
   * @param name the directive name
   * @param value the directive value.
   * @return fluent self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSPHandler addDirective(String name, String value) { 
    delegate.addDirective(name, value);
    return this;
  }

  /**
   * @param reportOnly enable report only
   * @return fluent self.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.CSPHandler setReportOnly(boolean reportOnly) { 
    delegate.setReportOnly(reportOnly);
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  CSPHandler newInstance(io.vertx.ext.web.handler.CSPHandler arg) {
    return arg != null ? new CSPHandler(arg) : null;
  }

}
