package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A handler which sets the response content type automatically according to the best <code>Accept</code> header match.
 *
 * The header is set only if:
 * <ul>
 * <li>no object is stored in the routing context under the name {@link io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler}</li>
 * <li>a match is found</li>
 * <li>the header is not present already</li>
 * <li>content length header is absent or set to something different than zero</li>
 * </ul>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ResponseContentTypeHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.ResponseContentTypeHandler.class)
public class ResponseContentTypeHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<ResponseContentTypeHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ResponseContentTypeHandler((io.vertx.ext.web.handler.ResponseContentTypeHandler) obj),
    ResponseContentTypeHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ResponseContentTypeHandler delegate;
  
  public ResponseContentTypeHandler(io.vertx.ext.web.handler.ResponseContentTypeHandler delegate) {
    this.delegate = delegate;
  }

  public ResponseContentTypeHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ResponseContentTypeHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ResponseContentTypeHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.ResponseContentTypeHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ResponseContentTypeHandler that = (ResponseContentTypeHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @return the response content type handler
   */
  public static io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler create() { 
    io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler ret = io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler.newInstance((io.vertx.ext.web.handler.ResponseContentTypeHandler)io.vertx.ext.web.handler.ResponseContentTypeHandler.create());
    return ret;
  }

  /**
   * @param disableFlag 
   * @return the response content type handler
   */
  public static io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler create(String disableFlag) { 
    io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler ret = io.vertx.mutiny.ext.web.handler.ResponseContentTypeHandler.newInstance((io.vertx.ext.web.handler.ResponseContentTypeHandler)io.vertx.ext.web.handler.ResponseContentTypeHandler.create(disableFlag));
    return ret;
  }

  public static final String DEFAULT_DISABLE_FLAG = io.vertx.ext.web.handler.ResponseContentTypeHandler.DEFAULT_DISABLE_FLAG;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  ResponseContentTypeHandler newInstance(io.vertx.ext.web.handler.ResponseContentTypeHandler arg) {
    return arg != null ? new ResponseContentTypeHandler(arg) : null;
  }

}
