package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * Represents a file-upload from an HTTP multipart form submission.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.FileUpload original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.FileUpload.class)
public class FileUpload {

  public static final io.smallrye.mutiny.vertx.TypeArg<FileUpload> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FileUpload((io.vertx.ext.web.FileUpload) obj),
    FileUpload::getDelegate
  );

  private final io.vertx.ext.web.FileUpload delegate;
  
  public FileUpload(io.vertx.ext.web.FileUpload delegate) {
    this.delegate = delegate;
  }

  public FileUpload(Object delegate) {
    this.delegate = (io.vertx.ext.web.FileUpload)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  FileUpload() {
    this.delegate = null;
  }

  public io.vertx.ext.web.FileUpload getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FileUpload that = (FileUpload) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return the name of the upload as provided in the form submission
   */
  public String name() { 
    String ret = delegate.name();
    return ret;
  }

  /**
   * @return the actual temporary file name on the server where the file was uploaded to.
   */
  public String uploadedFileName() { 
    String ret = delegate.uploadedFileName();
    return ret;
  }

  /**
   * @return the file name of the upload as provided in the form submission
   */
  public String fileName() { 
    String ret = delegate.fileName();
    return ret;
  }

  /**
   * @return the size of the upload, in bytes
   */
  public long size() { 
    long ret = delegate.size();
    return ret;
  }

  /**
   * @return the content type (MIME type) of the upload
   */
  public String contentType() { 
    String ret = delegate.contentType();
    return ret;
  }

  /**
   * @return the content transfer encoding of the upload - this describes how the upload was encoded in the form submission.
   */
  public String contentTransferEncoding() { 
    String ret = delegate.contentTransferEncoding();
    return ret;
  }

  /**
   * @return the charset of the upload
   */
  public String charSet() { 
    String ret = delegate.charSet();
    return ret;
  }

  /**
   * @return <code>true</code> when the upload was cancelled, <code>false</code> when the upload is finished and the file is available
   */
  public boolean cancel() { 
    boolean ret = delegate.cancel();
    return ret;
  }

  public static  FileUpload newInstance(io.vertx.ext.web.FileUpload arg) {
    return arg != null ? new FileUpload(arg) : null;
  }

}
