package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import java.util.List;
import io.vertx.core.json.JsonObject;

/**
 * An auth handler that provides OAuth2 Authentication support. This handler is suitable for AuthCode flows.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.OAuth2AuthHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.OAuth2AuthHandler.class)
public class OAuth2AuthHandler implements io.vertx.mutiny.ext.web.handler.AuthenticationHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<OAuth2AuthHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new OAuth2AuthHandler((io.vertx.ext.web.handler.OAuth2AuthHandler) obj),
    OAuth2AuthHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.OAuth2AuthHandler delegate;
  
  public OAuth2AuthHandler(io.vertx.ext.web.handler.OAuth2AuthHandler delegate) {
    this.delegate = delegate;
  }

  public OAuth2AuthHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.OAuth2AuthHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  OAuth2AuthHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.OAuth2AuthHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OAuth2AuthHandler that = (OAuth2AuthHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx the vertx instance
   * @param authProvider the auth provider to use
   * @param callbackURL the callback URL you entered in your provider admin console, usually it should be something like: `https://myserver:8888/callback`
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth authProvider, String callbackURL) { 
    io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler ret = io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler.newInstance((io.vertx.ext.web.handler.OAuth2AuthHandler)io.vertx.ext.web.handler.OAuth2AuthHandler.create(vertx.getDelegate(), authProvider.getDelegate(), callbackURL));
    return ret;
  }

  /**
   * @param vertx the vertx instance
   * @param authProvider the auth provider to use
   * @return the auth handler
   */
  public static io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler create(io.vertx.mutiny.core.Vertx vertx, io.vertx.mutiny.ext.auth.oauth2.OAuth2Auth authProvider) { 
    io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler ret = io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler.newInstance((io.vertx.ext.web.handler.OAuth2AuthHandler)io.vertx.ext.web.handler.OAuth2AuthHandler.create(vertx.getDelegate(), authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param extraParams extra optional parameters.
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler extraParams(JsonObject extraParams) { 
    delegate.extraParams(extraParams);
    return this;
  }

  /**
   * @param scope scope.
   * @return new instance of this interface.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler withScope(String scope) { 
    delegate.withScope(scope);
    return this;
  }

  /**
   * @param scopes scopes.
   * @return new instance of this interface.
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler withScopes(List<String> scopes) { 
    delegate.withScopes(scopes);
    return this;
  }

  /**
   * @param prompt the prompt choice.
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler prompt(String prompt) { 
    delegate.prompt(prompt);
    return this;
  }

  /**
   * @param length A number between 43 and 128. Or -1 to disable.
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler pkceVerifierLength(int length) { 
    delegate.pkceVerifierLength(length);
    return this;
  }

  /**
   * @param route a given route e.g.: `/callback`
   * @return self
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.OAuth2AuthHandler setupCallback(io.vertx.mutiny.ext.web.Route route) { 
    delegate.setupCallback(route.getDelegate());
    return this;
  }

  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  OAuth2AuthHandler newInstance(io.vertx.ext.web.handler.OAuth2AuthHandler arg) {
    return arg != null ? new OAuth2AuthHandler(arg) : null;
  }

}
