package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;

/**
 * Handler that handles login from a form on a custom login page.
 * <p>
 * Used in conjunction with the {@link io.vertx.mutiny.ext.web.handler.RedirectAuthHandler}.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.FormLoginHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.FormLoginHandler.class)
public class FormLoginHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<FormLoginHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new FormLoginHandler((io.vertx.ext.web.handler.FormLoginHandler) obj),
    FormLoginHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.FormLoginHandler delegate;
  
  public FormLoginHandler(io.vertx.ext.web.handler.FormLoginHandler delegate) {
    this.delegate = delegate;
  }

  public FormLoginHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.FormLoginHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  FormLoginHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.FormLoginHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    FormLoginHandler that = (FormLoginHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param authProvider the auth service to use
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FormLoginHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider) { 
    io.vertx.mutiny.ext.web.handler.FormLoginHandler ret = io.vertx.mutiny.ext.web.handler.FormLoginHandler.newInstance((io.vertx.ext.web.handler.FormLoginHandler)io.vertx.ext.web.handler.FormLoginHandler.create(authProvider.getDelegate()));
    return ret;
  }

  /**
   * @param authProvider the auth service to use
   * @param usernameParam the value of the form attribute which will contain the username
   * @param passwordParam the value of the form attribute which will contain the password
   * @param returnURLParam the value of the session attribute which will contain the return url
   * @param directLoggedInOKURL a url to redirect to if the user logs in directly at the url of the form login handler without being redirected here first
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.FormLoginHandler create(io.vertx.mutiny.ext.auth.authentication.AuthenticationProvider authProvider, String usernameParam, String passwordParam, String returnURLParam, String directLoggedInOKURL) { 
    io.vertx.mutiny.ext.web.handler.FormLoginHandler ret = io.vertx.mutiny.ext.web.handler.FormLoginHandler.newInstance((io.vertx.ext.web.handler.FormLoginHandler)io.vertx.ext.web.handler.FormLoginHandler.create(authProvider.getDelegate(), usernameParam, passwordParam, returnURLParam, directLoggedInOKURL));
    return ret;
  }

  /**
   * @param usernameParam the name of the param
   * @return a reference to this for a fluent API
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.FormLoginHandler setUsernameParam(String usernameParam) { 
    delegate.setUsernameParam(usernameParam);
    return this;
  }

  /**
   * @param passwordParam the name of the param
   * @return a reference to this for a fluent API
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.FormLoginHandler setPasswordParam(String passwordParam) { 
    delegate.setPasswordParam(passwordParam);
    return this;
  }

  /**
   * @param returnURLParam the name of the param
   * @return a reference to this for a fluent API
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.FormLoginHandler setReturnURLParam(String returnURLParam) { 
    delegate.setReturnURLParam(returnURLParam);
    return this;
  }

  /**
   * @param directLoggedInOKURL the URL to redirect to
   * @return a reference to this for a fluent API
   */
  @Fluent
  public io.vertx.mutiny.ext.web.handler.FormLoginHandler setDirectLoggedInOKURL(String directLoggedInOKURL) { 
    delegate.setDirectLoggedInOKURL(directLoggedInOKURL);
    return this;
  }

  /**
   * The default value of the form attribute which will contain the username
   */
  public static final String DEFAULT_USERNAME_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_USERNAME_PARAM;
  /**
   * The default value of the form attribute which will contain the password
   */
  public static final String DEFAULT_PASSWORD_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_PASSWORD_PARAM;
  /**
   * The default value of the session attribute which will contain the return url
   */
  public static final String DEFAULT_RETURN_URL_PARAM = io.vertx.ext.web.handler.FormLoginHandler.DEFAULT_RETURN_URL_PARAM;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  FormLoginHandler newInstance(io.vertx.ext.web.handler.FormLoginHandler arg) {
    return arg != null ? new FormLoginHandler(arg) : null;
  }

}
