package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;

/**
 * Base interface for auth handlers.
 * <p>
 * An auth handler allows your application to provide authentication support.
 * <p>
 * An Auth handler may require a {@link io.vertx.mutiny.ext.web.handler.SessionHandler} to be on the routing chain before it.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.AuthenticationHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.AuthenticationHandler.class)
public interface AuthenticationHandler extends io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.AuthenticationHandler getDelegate();

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0);

  default public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  AuthenticationHandler newInstance(io.vertx.ext.web.handler.AuthenticationHandler arg) {
    return arg != null ? new AuthenticationHandlerImpl(arg) : null;
  }

}

class AuthenticationHandlerImpl implements AuthenticationHandler {
  private final io.vertx.ext.web.handler.AuthenticationHandler delegate;
  
  public io.vertx.ext.web.handler.AuthenticationHandler getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  AuthenticationHandlerImpl() {
    this.delegate = null;
  }

  public AuthenticationHandlerImpl(io.vertx.ext.web.handler.AuthenticationHandler delegate) {
    this.delegate = delegate;
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

}
