/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class UniOnItemConsume<T, E>
extends UniOperator<T, T> {
    private final Consumer<? super T> onItemCallback;
    private final Consumer<E> onFailureCallback;
    private final Predicate<? super Throwable> onFailurePredicate;
    private final Class<E> throwableType;

    public UniOnItemConsume(Uni<? extends T> upstream, Consumer<? super T> onItemCallback, Consumer<E> onFailureCallback, Predicate<? super Throwable> predicate, Class<E> throwableType) {
        super(upstream);
        this.onItemCallback = onItemCallback;
        this.onFailureCallback = onFailureCallback;
        this.onFailurePredicate = predicate;
        this.throwableType = throwableType;
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnItemComsumeProcessor(subscriber));
    }

    private class UniOnItemComsumeProcessor
    extends UniOperatorProcessor<T, T> {
        public UniOnItemComsumeProcessor(UniSubscriber<? super T> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(T item) {
            if (!this.isCancelled() && this.invokeEventHandler(UniOnItemConsume.this.onItemCallback, item, false, this.downstream)) {
                this.downstream.onItem(item);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            block9: {
                if (!this.isCancelled()) {
                    if (UniOnItemConsume.this.onFailurePredicate != null) {
                        try {
                            if (UniOnItemConsume.this.onFailurePredicate.test(failure)) {
                                if (this.invokeEventHandler(UniOnItemConsume.this.onFailureCallback, UniOnItemConsume.this.throwableType.cast(failure), true, this.downstream)) {
                                    this.downstream.onFailure(failure);
                                }
                                break block9;
                            }
                            this.downstream.onFailure(failure);
                        }
                        catch (Throwable e) {
                            this.downstream.onFailure(new CompositeException(failure, e));
                        }
                    } else if (this.invokeEventHandler(UniOnItemConsume.this.onFailureCallback, UniOnItemConsume.this.throwableType.cast(failure), true, this.downstream)) {
                        this.downstream.onFailure(failure);
                    }
                } else {
                    Infrastructure.handleDroppedException(failure);
                }
            }
        }

        private <E> boolean invokeEventHandler(Consumer<? super E> handler, E event, boolean wasCalledByOnFailure, UniSubscriber<? super T> subscriber) {
            if (handler != null) {
                try {
                    handler.accept(event);
                }
                catch (Throwable e) {
                    if (wasCalledByOnFailure) {
                        subscriber.onFailure(new CompositeException((Throwable)event, e));
                    } else {
                        subscriber.onFailure(e);
                    }
                    return false;
                }
            }
            return true;
        }
    }
}

