/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.BiFunction;

public class UniOnItemOrFailureMap<I, O>
extends UniOperator<I, O> {
    private final BiFunction<? super I, Throwable, ? extends O> mapper;

    public UniOnItemOrFailureMap(Uni<I> upstream, BiFunction<? super I, Throwable, ? extends O> mapper) {
        super(upstream);
        this.mapper = mapper;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> downstream) {
        AbstractUni.subscribe(this.upstream(), new UniOnItemOrFailureMapProcessor(downstream));
    }

    private class UniOnItemOrFailureMapProcessor
    extends UniOperatorProcessor<I, O> {
        public UniOnItemOrFailureMapProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(I item) {
            if (!this.isCancelled()) {
                Object outcome;
                try {
                    outcome = UniOnItemOrFailureMap.this.mapper.apply(item, null);
                }
                catch (Throwable e) {
                    this.downstream.onFailure(e);
                    return;
                }
                this.downstream.onItem(outcome);
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (!this.isCancelled()) {
                Object outcome;
                try {
                    outcome = UniOnItemOrFailureMap.this.mapper.apply(null, failure);
                }
                catch (Throwable e) {
                    this.downstream.onFailure(new CompositeException(failure, e));
                    return;
                }
                this.downstream.onItem(outcome);
            } else {
                Infrastructure.handleDroppedException(failure);
            }
        }
    }
}

