/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import io.smallrye.mutiny.tuples.Functions;

public class UniOnTermination<T>
extends UniOperator<T, T> {
    private final Functions.TriConsumer<T, Throwable, Boolean> callback;

    public UniOnTermination(Uni<T> upstream, Functions.TriConsumer<T, Throwable, Boolean> callback) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.callback = ParameterValidation.nonNull(callback, "callback");
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniDelegatingSubscriber<T, T>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                super.onSubscribe(() -> {
                    subscription.cancel();
                    UniOnTermination.this.callback.accept(null, null, true);
                });
            }

            @Override
            public void onItem(T item) {
                try {
                    UniOnTermination.this.callback.accept(item, null, false);
                }
                catch (Throwable e) {
                    subscriber.onFailure(e);
                    return;
                }
                subscriber.onItem(item);
            }

            @Override
            public void onFailure(Throwable failure) {
                try {
                    UniOnTermination.this.callback.accept(null, failure, false);
                }
                catch (Throwable e) {
                    subscriber.onFailure(new CompositeException(failure, e));
                    return;
                }
                subscriber.onFailure(failure);
            }
        });
    }
}

