/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniRetry;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.UniOnFailureFlatMap;
import io.smallrye.mutiny.operators.UniOnFailureTransform;
import io.smallrye.mutiny.operators.UniOnItemConsume;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class UniOnFailure<T> {
    private final Uni<T> upstream;
    private final Predicate<? super Throwable> predicate;

    public UniOnFailure(Uni<T> upstream, Predicate<? super Throwable> predicate) {
        this.upstream = upstream;
        this.predicate = predicate == null ? x -> true : predicate;
    }

    public Uni<T> invoke(Consumer<Throwable> callback) {
        return Infrastructure.onUniCreation(new UniOnItemConsume<T>(this.upstream, null, ParameterValidation.nonNull(callback, "callback"), this.predicate));
    }

    public Uni<T> invoke(Runnable callback) {
        Runnable actual = ParameterValidation.nonNull(callback, "callback");
        return this.invoke((Throwable ignored) -> actual.run());
    }

    @Deprecated
    public Uni<T> invokeUni(Function<Throwable, Uni<?>> action) {
        return this.call(action);
    }

    public Uni<T> call(Function<Throwable, Uni<?>> action) {
        ParameterValidation.nonNull(action, "action");
        return this.recoverWithUni((? super Throwable failure) -> {
            Uni uni = (Uni)Objects.requireNonNull(action.apply((Throwable)failure), "The `action` produced a `null` uni");
            return uni.onItem().failWith(ignored -> failure).onFailure().apply(subFailure -> new CompositeException((Throwable)failure, (Throwable)subFailure));
        });
    }

    public Uni<T> call(Supplier<Uni<?>> supplier) {
        Supplier<Uni<?>> actual = ParameterValidation.nonNull(supplier, "supplier");
        return this.call((Throwable ignored) -> (Uni)actual.get());
    }

    @Deprecated
    public Uni<T> apply(Function<? super Throwable, ? extends Throwable> mapper) {
        return this.transform(mapper);
    }

    public Uni<T> transform(Function<? super Throwable, ? extends Throwable> mapper) {
        return Infrastructure.onUniCreation(new UniOnFailureTransform(this.upstream, this.predicate, mapper));
    }

    public Uni<T> recoverWithItem(T fallback) {
        return this.recoverWithItem(() -> fallback);
    }

    public Uni<T> recoverWithItem(Supplier<T> supplier) {
        ParameterValidation.nonNull(supplier, "supplier");
        return this.recoverWithItem((? super Throwable ignored) -> supplier.get());
    }

    public Uni<T> recoverWithItem(Function<? super Throwable, ? extends T> function) {
        ParameterValidation.nonNull(function, "function");
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap(this.upstream, this.predicate, failure -> {
            Object newResult = function.apply((Throwable)failure);
            return Uni.createFrom().item(newResult);
        }));
    }

    public Uni<T> recoverWithUni(Function<? super Throwable, Uni<? extends T>> function) {
        return Infrastructure.onUniCreation(new UniOnFailureFlatMap(this.upstream, this.predicate, ParameterValidation.nonNull(function, "function")));
    }

    public Uni<T> recoverWithUni(Supplier<Uni<? extends T>> supplier) {
        return this.recoverWithUni((? super Throwable ignored) -> (Uni)supplier.get());
    }

    public Uni<T> recoverWithUni(Uni<? extends T> fallback) {
        return this.recoverWithUni(() -> fallback);
    }

    public UniRetry<T> retry() {
        return new UniRetry<T>(this.upstream, this.predicate);
    }
}

