/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex.gizmo2;

import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.creator.AccessLevel;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.creator.ClassCreator;
import io.quarkus.gizmo2.creator.FieldCreator;
import io.quarkus.gizmo2.creator.MethodCreator;
import io.quarkus.gizmo2.creator.ModifiableCreator;
import io.quarkus.gizmo2.creator.Modifier;
import io.quarkus.gizmo2.creator.ModifierFlag;
import io.quarkus.gizmo2.creator.TypeParameterizedCreator;
import io.quarkus.gizmo2.desc.ClassMethodDesc;
import io.quarkus.gizmo2.desc.ConstructorDesc;
import io.quarkus.gizmo2.desc.FieldDesc;
import io.quarkus.gizmo2.desc.InterfaceMethodDesc;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.MethodTypeDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ArrayType;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;
import org.jboss.jandex.WildcardType;

public class Jandex2Gizmo {
    private static final Map<DotName, ClassDesc> CLASS_DESC_CACHE = new ConcurrentHashMap<DotName, ClassDesc>();

    public static ClassDesc classDescOf(DotName name) {
        ClassDesc classDesc = CLASS_DESC_CACHE.get(name);
        if (classDesc != null) {
            return classDesc;
        }
        return CLASS_DESC_CACHE.computeIfAbsent(name, nameParam -> {
            if (nameParam.prefix() == null) {
                String local;
                return switch (local = nameParam.local()) {
                    case "void" -> ConstantDescs.CD_void;
                    case "boolean" -> ConstantDescs.CD_boolean;
                    case "byte" -> ConstantDescs.CD_byte;
                    case "short" -> ConstantDescs.CD_short;
                    case "int" -> ConstantDescs.CD_int;
                    case "long" -> ConstantDescs.CD_long;
                    case "float" -> ConstantDescs.CD_float;
                    case "double" -> ConstantDescs.CD_double;
                    case "char" -> ConstantDescs.CD_char;
                    default -> Jandex2Gizmo.ofClassOrArray(local);
                };
            }
            return Jandex2Gizmo.ofClassOrArray(nameParam.toString());
        });
    }

    private static ClassDesc ofClassOrArray(String name) {
        int dimensions = 0;
        while (name.charAt(dimensions) == '[') {
            ++dimensions;
        }
        if (dimensions == 0) {
            return ClassDesc.of(name);
        }
        ClassDesc elementType = name.charAt(dimensions) == 'L' ? ClassDesc.of(name.substring(dimensions + 1, name.length() - 1)) : ClassDesc.ofDescriptor(name.substring(dimensions));
        return elementType.arrayType(dimensions);
    }

    public static ClassDesc classDescOf(Type type) {
        return switch (type.kind()) {
            case Type.Kind.VOID -> ConstantDescs.CD_void;
            case Type.Kind.PRIMITIVE -> {
                switch (type.asPrimitiveType().primitive()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BOOLEAN: {
                        yield ConstantDescs.CD_boolean;
                    }
                    case BYTE: {
                        yield ConstantDescs.CD_byte;
                    }
                    case SHORT: {
                        yield ConstantDescs.CD_short;
                    }
                    case INT: {
                        yield ConstantDescs.CD_int;
                    }
                    case LONG: {
                        yield ConstantDescs.CD_long;
                    }
                    case FLOAT: {
                        yield ConstantDescs.CD_float;
                    }
                    case DOUBLE: {
                        yield ConstantDescs.CD_double;
                    }
                    case CHAR: 
                }
                yield ConstantDescs.CD_char;
            }
            case Type.Kind.ARRAY -> {
                ArrayType arrayType = type.asArrayType();
                ClassDesc element = Jandex2Gizmo.classDescOf(arrayType.elementType());
                yield element.arrayType(arrayType.deepDimensions());
            }
            default -> Jandex2Gizmo.classDescOf(type.name());
        };
    }

    public static ClassDesc classDescOf(ClassInfo clazz) {
        return Jandex2Gizmo.classDescOf(clazz.name());
    }

    public static FieldDesc fieldDescOf(FieldInfo field) {
        return FieldDesc.of((ClassDesc)Jandex2Gizmo.classDescOf(field.declaringClass()), (String)field.name(), (ClassDesc)Jandex2Gizmo.classDescOf(field.type()));
    }

    public static MethodDesc methodDescOf(MethodInfo method) {
        if (method.isConstructor()) {
            throw new IllegalArgumentException("Cannot create MethodDesc for constructor: " + String.valueOf(method));
        }
        if (method.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot create MethodDesc for static initializer: " + String.valueOf(method));
        }
        ClassDesc owner = Jandex2Gizmo.classDescOf(method.declaringClass());
        ClassDesc returnType = Jandex2Gizmo.classDescOf(method.returnType());
        ClassDesc[] paramTypes = new ClassDesc[method.parametersCount()];
        for (int i = 0; i < method.parametersCount(); ++i) {
            paramTypes[i] = Jandex2Gizmo.classDescOf(method.parameterType(i));
        }
        MethodTypeDesc methodTypeDesc = MethodTypeDesc.of(returnType, paramTypes);
        return method.declaringClass().isInterface() ? InterfaceMethodDesc.of((ClassDesc)owner, (String)method.name(), (MethodTypeDesc)methodTypeDesc) : ClassMethodDesc.of((ClassDesc)owner, (String)method.name(), (MethodTypeDesc)methodTypeDesc);
    }

    public static ConstructorDesc constructorDescOf(MethodInfo ctor) {
        if (ctor.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot create ConstructorDesc for static initializer: " + String.valueOf(ctor));
        }
        if (!ctor.isConstructor()) {
            throw new IllegalArgumentException("Cannot create ConstructorDesc for regular method: " + String.valueOf(ctor));
        }
        ArrayList<ClassDesc> paramTypes = new ArrayList<ClassDesc>(ctor.parametersCount());
        for (int i = 0; i < ctor.parametersCount(); ++i) {
            paramTypes.add(Jandex2Gizmo.classDescOf(ctor.parameterType(i)));
        }
        return ConstructorDesc.of((ClassDesc)Jandex2Gizmo.classDescOf(ctor.declaringClass()), paramTypes);
    }

    public static GenericType genericTypeOf(DotName name) {
        return GenericType.of((ClassDesc)Jandex2Gizmo.classDescOf(name));
    }

    public static GenericType genericTypeOf(Type type) {
        return Jandex2Gizmo.genericTypeOf(type, null);
    }

    public static GenericType genericTypeOf(Type type, IndexView index) {
        return switch (type.kind()) {
            case Type.Kind.VOID, Type.Kind.PRIMITIVE -> Jandex2Gizmo.genericTypeOfPrimitive(type, index);
            default -> Jandex2Gizmo.genericTypeOfReference(type, index);
        };
    }

    public static GenericType.OfPrimitive genericTypeOfPrimitive(Type type) {
        return Jandex2Gizmo.genericTypeOfPrimitive(type, null);
    }

    public static GenericType.OfPrimitive genericTypeOfPrimitive(Type type, IndexView index) {
        GenericType.OfPrimitive result = switch (type.kind()) {
            case Type.Kind.VOID -> GenericType.ofPrimitive(Void.TYPE);
            case Type.Kind.PRIMITIVE -> {
                switch (type.asPrimitiveType().primitive()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BOOLEAN: {
                        yield GenericType.ofPrimitive(Boolean.TYPE);
                    }
                    case BYTE: {
                        yield GenericType.ofPrimitive(Byte.TYPE);
                    }
                    case SHORT: {
                        yield GenericType.ofPrimitive(Short.TYPE);
                    }
                    case INT: {
                        yield GenericType.ofPrimitive(Integer.TYPE);
                    }
                    case LONG: {
                        yield GenericType.ofPrimitive(Long.TYPE);
                    }
                    case FLOAT: {
                        yield GenericType.ofPrimitive(Float.TYPE);
                    }
                    case DOUBLE: {
                        yield GenericType.ofPrimitive(Double.TYPE);
                    }
                    case CHAR: 
                }
                yield GenericType.ofPrimitive(Character.TYPE);
            }
            default -> throw new IllegalArgumentException("Not a primitive type: " + String.valueOf(type));
        };
        return index == null ? result : result.withAnnotations(Jandex2Gizmo.copyAnnotations(type, index));
    }

    public static GenericType.OfReference genericTypeOfReference(Type type) {
        return Jandex2Gizmo.genericTypeOfReference(type, null);
    }

    public static GenericType.OfReference genericTypeOfReference(Type type, IndexView index) {
        return switch (type.kind()) {
            case Type.Kind.VOID, Type.Kind.PRIMITIVE -> throw new IllegalArgumentException("Not a reference type: " + String.valueOf(type));
            case Type.Kind.ARRAY -> Jandex2Gizmo.genericTypeOfArray(type, index);
            default -> Jandex2Gizmo.genericTypeOfThrows(type, index);
        };
    }

    public static GenericType.OfArray genericTypeOfArray(Type type) {
        return Jandex2Gizmo.genericTypeOfArray(type, null);
    }

    public static GenericType.OfArray genericTypeOfArray(Type type, IndexView index) {
        if (type.kind() != Type.Kind.ARRAY) {
            throw new IllegalArgumentException("Not an array type: " + String.valueOf(type));
        }
        GenericType constituent = Jandex2Gizmo.genericTypeOf(type.asArrayType().constituent(), index);
        GenericType.OfArray result = constituent.arrayType();
        for (int i = 1; i < type.asArrayType().dimensions(); ++i) {
            result = result.arrayType();
        }
        assert (result != null);
        return index == null ? result : result.withAnnotations(Jandex2Gizmo.copyAnnotations(type, index));
    }

    public static GenericType.OfThrows genericTypeOfThrows(Type type) {
        return Jandex2Gizmo.genericTypeOfThrows(type, null);
    }

    public static GenericType.OfThrows genericTypeOfThrows(Type type, IndexView index) {
        return switch (type.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.Kind.VOID, Type.Kind.PRIMITIVE, Type.Kind.ARRAY -> throw new IllegalArgumentException("Not a throwable type: " + String.valueOf(type));
            case Type.Kind.CLASS, Type.Kind.PARAMETERIZED_TYPE -> Jandex2Gizmo.genericTypeOfClass(type, index);
            case Type.Kind.TYPE_VARIABLE, Type.Kind.TYPE_VARIABLE_REFERENCE, Type.Kind.UNRESOLVED_TYPE_VARIABLE -> Jandex2Gizmo.genericTypeOfTypeVariable(type, index);
            case Type.Kind.WILDCARD_TYPE -> throw new IllegalArgumentException("Wildcard types may only be type arguments");
        };
    }

    public static GenericType.OfClass genericTypeOfClass(Type type) {
        return Jandex2Gizmo.genericTypeOfClass(type, null);
    }

    public static GenericType.OfClass genericTypeOfClass(Type type, IndexView index) {
        GenericType.OfClass result = switch (type.kind()) {
            case Type.Kind.CLASS -> GenericType.ofClass((ClassDesc)Jandex2Gizmo.classDescOf(type.name()));
            case Type.Kind.PARAMETERIZED_TYPE -> {
                List typeArgs = type.asParameterizedType().arguments();
                ArrayList<TypeArgument> translatedTypeArgs = new ArrayList<TypeArgument>(typeArgs.size());
                for (Type typeArg : typeArgs) {
                    translatedTypeArgs.add(Jandex2Gizmo.typeArgumentOf(typeArg, index));
                }
                Type owner = type.asParameterizedType().owner();
                if (owner != null) {
                    GenericType.OfClass translatedOwner = Jandex2Gizmo.genericTypeOfClass(owner, index);
                    yield GenericType.ofInnerClass((GenericType.OfClass)translatedOwner, (String)type.name().local()).withArguments(translatedTypeArgs);
                }
                yield GenericType.ofClass((ClassDesc)Jandex2Gizmo.classDescOf(type.name()), translatedTypeArgs);
            }
            default -> throw new IllegalArgumentException("Not a class/parameterized type: " + String.valueOf(type));
        };
        return index == null ? result : result.withAnnotations(Jandex2Gizmo.copyAnnotations(type, index));
    }

    public static GenericType.OfTypeVariable genericTypeOfTypeVariable(Type type) {
        return Jandex2Gizmo.genericTypeOfTypeVariable(type, null);
    }

    public static GenericType.OfTypeVariable genericTypeOfTypeVariable(Type type, IndexView index) {
        GenericType.OfTypeVariable result = switch (type.kind()) {
            case Type.Kind.TYPE_VARIABLE -> GenericType.ofTypeVariable((String)type.asTypeVariable().identifier(), (ClassDesc)Jandex2Gizmo.classDescOf(type.name()));
            case Type.Kind.TYPE_VARIABLE_REFERENCE -> GenericType.ofTypeVariable((String)type.asTypeVariableReference().identifier(), (ClassDesc)Jandex2Gizmo.classDescOf(type.name()));
            case Type.Kind.UNRESOLVED_TYPE_VARIABLE -> GenericType.ofTypeVariable((String)type.asUnresolvedTypeVariable().identifier(), (ClassDesc)ConstantDescs.CD_Object);
            default -> throw new IllegalArgumentException("Not a type variable: " + String.valueOf(type));
        };
        return index == null ? result : result.withAnnotations(Jandex2Gizmo.copyAnnotations(type, index));
    }

    public static TypeArgument typeArgumentOf(Type type) {
        return Jandex2Gizmo.typeArgumentOf(type, null);
    }

    public static TypeArgument typeArgumentOf(Type type, IndexView index) {
        return switch (type.kind()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.Kind.VOID, Type.Kind.PRIMITIVE -> throw new IllegalArgumentException("Primitive types cannot be type arguments");
            case Type.Kind.ARRAY, Type.Kind.CLASS, Type.Kind.PARAMETERIZED_TYPE, Type.Kind.TYPE_VARIABLE, Type.Kind.TYPE_VARIABLE_REFERENCE, Type.Kind.UNRESOLVED_TYPE_VARIABLE -> TypeArgument.ofExact((GenericType.OfReference)Jandex2Gizmo.genericTypeOfReference(type, index));
            case Type.Kind.WILDCARD_TYPE -> {
                WildcardType wildcard = type.asWildcardType();
                Object result = wildcard.superBound() != null ? TypeArgument.ofSuper((GenericType.OfReference)Jandex2Gizmo.genericTypeOfReference(wildcard.superBound(), index)) : (wildcard.extendsBound() != null && (!DotName.OBJECT_NAME.equals((Object)wildcard.extendsBound().name()) || !wildcard.extendsBound().annotations().isEmpty()) ? TypeArgument.ofExtends((GenericType.OfReference)Jandex2Gizmo.genericTypeOfReference(wildcard.extendsBound(), index)) : TypeArgument.ofUnbounded());
                if (index == null) {
                    yield result;
                }
                yield result.withAnnotations(Jandex2Gizmo.copyAnnotations(type, index));
            }
        };
    }

    public static void copyTypeParameters(ClassInfo clazz, TypeParameterizedCreator creator) {
        Jandex2Gizmo.copyTypeParameters(clazz.typeParameters(), creator);
    }

    public static void copyTypeParameters(MethodInfo method, TypeParameterizedCreator creator) {
        Jandex2Gizmo.copyTypeParameters(method.typeParameters(), creator);
    }

    private static void copyTypeParameters(List<TypeVariable> typeParameters, TypeParameterizedCreator creator) {
        for (TypeVariable typeParameter : typeParameters) {
            Jandex2Gizmo.addTypeParameter(typeParameter, creator);
        }
    }

    public static void addTypeParameter(TypeVariable typeParameter, TypeParameterizedCreator creator) {
        List bounds = typeParameter.bounds();
        if (bounds.isEmpty()) {
            creator.typeParameter(typeParameter.identifier());
        } else if (bounds.get(0) instanceof TypeVariable) {
            creator.typeParameter(typeParameter.identifier(), tpc -> tpc.setFirstBound(Jandex2Gizmo.genericTypeOfTypeVariable((Type)bounds.get(0))));
        } else {
            creator.typeParameter(typeParameter.identifier(), tpc -> {
                int firstInterfaceBound = 0;
                if (!typeParameter.hasImplicitObjectBound()) {
                    tpc.setFirstBound(Jandex2Gizmo.genericTypeOfClass((Type)bounds.get(0)));
                    firstInterfaceBound = 1;
                }
                if (typeParameter.bounds().size() > firstInterfaceBound) {
                    ArrayList<GenericType.OfClass> other = new ArrayList<GenericType.OfClass>(bounds.size() - firstInterfaceBound);
                    for (int i = firstInterfaceBound; i < bounds.size(); ++i) {
                        other.add(Jandex2Gizmo.genericTypeOfClass((Type)bounds.get(i)));
                    }
                    tpc.setOtherBounds(other);
                }
            });
        }
    }

    public static Consumer<AnnotatableCreator> copyAnnotations(AnnotationTarget annotationTarget, IndexView index) {
        return creator -> {
            for (AnnotationInstance annotation : annotationTarget.annotations()) {
                Jandex2Gizmo.addAnnotation(creator, annotation, index);
            }
        };
    }

    public static Consumer<AnnotatableCreator> copyAnnotations(Type type, IndexView index) {
        return creator -> {
            for (AnnotationInstance annotation : type.annotations()) {
                Jandex2Gizmo.addAnnotation(creator, annotation, index);
            }
        };
    }

    public static void addAnnotation(AnnotatableCreator annotatableCreator, AnnotationInstance annotation, IndexView index) {
        RetentionPolicy retention = annotation.runtimeVisible() ? RetentionPolicy.RUNTIME : RetentionPolicy.CLASS;
        annotatableCreator.addAnnotation(Jandex2Gizmo.classDescOf(annotation.name()), retention, Jandex2Gizmo.creatorFor(annotation, index));
    }

    private static Consumer<AnnotationCreator<Annotation>> creatorFor(AnnotationInstance annotation, IndexView index) {
        return creator -> {
            for (AnnotationValue member : annotation.values()) {
                block0 : switch (member.kind()) {
                    case BOOLEAN: {
                        creator.add(member.name(), member.asBoolean());
                        break;
                    }
                    case BYTE: {
                        creator.add(member.name(), member.asByte());
                        break;
                    }
                    case SHORT: {
                        creator.add(member.name(), member.asShort());
                        break;
                    }
                    case INTEGER: {
                        creator.add(member.name(), member.asInt());
                        break;
                    }
                    case LONG: {
                        creator.add(member.name(), member.asLong());
                        break;
                    }
                    case FLOAT: {
                        creator.add(member.name(), member.asFloat());
                        break;
                    }
                    case DOUBLE: {
                        creator.add(member.name(), member.asDouble());
                        break;
                    }
                    case CHARACTER: {
                        creator.add(member.name(), member.asChar());
                        break;
                    }
                    case STRING: {
                        creator.add(member.name(), member.asString());
                        break;
                    }
                    case CLASS: {
                        creator.add(member.name(), Jandex2Gizmo.classDescOf(member.asClass()));
                        break;
                    }
                    case ENUM: {
                        creator.add(member.name(), Jandex2Gizmo.classDescOf(member.asEnumType()), member.asEnum());
                        break;
                    }
                    case NESTED: {
                        creator.add(member.name(), Jandex2Gizmo.classDescOf(member.asNested().name()), Jandex2Gizmo.creatorFor(member.asNested(), index));
                        break;
                    }
                    case ARRAY: {
                        switch (member.componentKind()) {
                            case BOOLEAN: {
                                creator.addArray(member.name(), member.asBooleanArray());
                                break block0;
                            }
                            case BYTE: {
                                creator.addArray(member.name(), member.asByteArray());
                                break block0;
                            }
                            case SHORT: {
                                creator.addArray(member.name(), member.asShortArray());
                                break block0;
                            }
                            case INTEGER: {
                                creator.addArray(member.name(), member.asIntArray());
                                break block0;
                            }
                            case LONG: {
                                creator.addArray(member.name(), member.asLongArray());
                                break block0;
                            }
                            case FLOAT: {
                                creator.addArray(member.name(), member.asFloatArray());
                                break block0;
                            }
                            case DOUBLE: {
                                creator.addArray(member.name(), member.asDoubleArray());
                                break block0;
                            }
                            case CHARACTER: {
                                creator.addArray(member.name(), member.asCharArray());
                                break block0;
                            }
                            case STRING: {
                                creator.addArray(member.name(), member.asStringArray());
                                break block0;
                            }
                            case CLASS: {
                                Type[] in = member.asClassArray();
                                ClassDesc[] out = new ClassDesc[in.length];
                                for (int i = 0; i < in.length; ++i) {
                                    out[i] = Jandex2Gizmo.classDescOf(in[i]);
                                }
                                creator.addArray(member.name(), out);
                                break block0;
                            }
                            case ENUM: {
                                DotName[] array = member.asEnumTypeArray();
                                assert (array.length > 0);
                                ClassDesc enumType = Jandex2Gizmo.classDescOf(array[0]);
                                creator.addArray(member.name(), enumType, member.asEnumArray());
                                break block0;
                            }
                            case NESTED: {
                                DotName[] array = member.asNestedArray();
                                assert (array.length > 0);
                                ClassDesc nestedType = Jandex2Gizmo.classDescOf(array[0].name());
                                ArrayList<Consumer<AnnotationCreator<Annotation>>> creators = new ArrayList<Consumer<AnnotationCreator<Annotation>>>(array.length);
                                for (DotName nested : array) {
                                    creators.add(Jandex2Gizmo.creatorFor((AnnotationInstance)nested, index));
                                }
                                creator.addArray(member.name(), nestedType, creators);
                                break block0;
                            }
                            case UNKNOWN: {
                                ClassInfo annotationClass = index.getClassByName(annotation.name());
                                if (annotationClass == null) {
                                    throw new IllegalArgumentException("Given index does not contain " + String.valueOf(annotation.name()));
                                }
                                MethodInfo memberMethod = annotationClass.method(member.name(), new Type[0]);
                                assert (memberMethod.returnType().kind() == Type.Kind.ARRAY);
                                Type type = memberMethod.returnType().asArrayType().elementType();
                                if (PrimitiveType.BOOLEAN.equals((Object)type)) {
                                    creator.addArray(member.name(), new boolean[0]);
                                    break block0;
                                }
                                if (PrimitiveType.BYTE.equals((Object)type)) {
                                    creator.addArray(member.name(), new byte[0]);
                                    break block0;
                                }
                                if (PrimitiveType.SHORT.equals((Object)type)) {
                                    creator.addArray(member.name(), new short[0]);
                                    break block0;
                                }
                                if (PrimitiveType.INT.equals((Object)type)) {
                                    creator.addArray(member.name(), new int[0]);
                                    break block0;
                                }
                                if (PrimitiveType.LONG.equals((Object)type)) {
                                    creator.addArray(member.name(), new long[0]);
                                    break block0;
                                }
                                if (PrimitiveType.FLOAT.equals((Object)type)) {
                                    creator.addArray(member.name(), new float[0]);
                                    break block0;
                                }
                                if (PrimitiveType.DOUBLE.equals((Object)type)) {
                                    creator.addArray(member.name(), new double[0]);
                                    break block0;
                                }
                                if (PrimitiveType.CHAR.equals((Object)type)) {
                                    creator.addArray(member.name(), new char[0]);
                                    break block0;
                                }
                                if (DotName.STRING_NAME.equals((Object)type.name())) {
                                    creator.addArray(member.name(), new String[0]);
                                    break block0;
                                }
                                if (DotName.CLASS_NAME.equals((Object)type.name())) {
                                    creator.addArray(member.name(), new Class[0]);
                                    break block0;
                                }
                                assert (type.kind() == Type.Kind.CLASS);
                                ClassInfo clazz = index.getClassByName(type.name());
                                if (clazz.isEnum()) {
                                    creator.addArray(member.name(), Jandex2Gizmo.classDescOf(clazz), new String[0]);
                                    break block0;
                                }
                                if (clazz.isAnnotation()) {
                                    creator.addArray(member.name(), Jandex2Gizmo.classDescOf(clazz), List.of());
                                    break block0;
                                }
                                throw new IllegalArgumentException("Unknown type of empty array: " + String.valueOf(memberMethod) + " at " + String.valueOf(memberMethod.declaringClass()));
                            }
                            default: {
                                throw Assert.impossibleSwitchCase((Object)member.kind());
                            }
                        }
                    }
                    default: {
                        throw Assert.impossibleSwitchCase((Object)member.kind());
                    }
                }
            }
        };
    }

    public static Const constOfEnum(FieldInfo enumConstant) {
        if (!enumConstant.isEnumConstant()) {
            throw new IllegalArgumentException("Not an enum constant: " + String.valueOf(enumConstant));
        }
        return Const.of(Enum.EnumDesc.of(Jandex2Gizmo.classDescOf(enumConstant.declaringClass()), enumConstant.name()));
    }

    public static void copyModifiers(ClassInfo clazz, ClassCreator creator) {
        Jandex2Gizmo.copyModifiers(clazz.flags(), (ModifiableCreator)creator);
    }

    public static void copyModifiers(MethodInfo method, MethodCreator creator) {
        Jandex2Gizmo.copyModifiers(method.flags(), (ModifiableCreator)creator);
    }

    public static void copyModifiers(FieldInfo field, FieldCreator creator) {
        Jandex2Gizmo.copyModifiers(field.flags(), (ModifiableCreator)creator);
    }

    private static void copyModifiers(int flags, ModifiableCreator creator) {
        for (ModifierFlag flag : ModifierFlag.values()) {
            if (!creator.supports((Modifier)flag) || (flags & flag.mask()) != flag.mask()) continue;
            creator.addFlag(flag);
        }
        creator.setAccess(AccessLevel.of((int)flags));
    }
}

