/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.os;

import java.util.Locale;

public enum OS {
    AIX,
    LINUX,
    MAC,
    SOLARIS,
    WINDOWS,
    Z,
    OTHER;

    private static final OS CURRENT_OS;

    private static OS determineCurrentOs() {
        return OS.parse(System.getProperty("os.name", "unknown"));
    }

    static OS parse(String osName) {
        if ((osName = osName.toLowerCase(Locale.ENGLISH)).contains("linux")) {
            return LINUX;
        }
        if (osName.contains("windows")) {
            return WINDOWS;
        }
        if (osName.contains("mac") || osName.contains("darwin")) {
            return MAC;
        }
        if (osName.contains("sunos") || osName.contains("solaris")) {
            return SOLARIS;
        }
        if (osName.contains("aix")) {
            return AIX;
        }
        if (osName.contains("z/os")) {
            return Z;
        }
        return OTHER;
    }

    public boolean isCurrent() {
        return this == CURRENT_OS;
    }

    public static OS current() {
        return CURRENT_OS;
    }

    static {
        CURRENT_OS = OS.determineCurrentOs();
    }
}

