/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.instruction;

import io.smallrye.classfile.Instruction;
import io.smallrye.classfile.Opcode;
import io.smallrye.classfile.constantpool.ClassEntry;
import io.smallrye.classfile.constantpool.MemberRefEntry;
import io.smallrye.classfile.constantpool.NameAndTypeEntry;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.AbstractInstruction;
import io.smallrye.classfile.impl.TemporaryConstantPool;
import io.smallrye.classfile.impl.Util;
import java.lang.constant.MethodTypeDesc;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface InvokeInstruction
extends Instruction {
    public MemberRefEntry method();

    public boolean isInterface();

    public int count();

    default public ClassEntry owner() {
        return this.method().owner();
    }

    default public Utf8Entry name() {
        return this.method().nameAndType().name();
    }

    default public Utf8Entry type() {
        return this.method().nameAndType().type();
    }

    default public MethodTypeDesc typeSymbol() {
        return Util.methodTypeSymbol(this.method().type());
    }

    public static InvokeInstruction of(Opcode op, MemberRefEntry method) {
        Util.checkKind(op, Opcode.Kind.INVOKE);
        return new AbstractInstruction.UnboundInvokeInstruction(op, method);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, Utf8Entry name, Utf8Entry type, boolean isInterface) {
        return InvokeInstruction.of(op, owner, TemporaryConstantPool.INSTANCE.nameAndTypeEntry(name, type), isInterface);
    }

    public static InvokeInstruction of(Opcode op, ClassEntry owner, NameAndTypeEntry nameAndType, boolean isInterface) {
        return InvokeInstruction.of(op, isInterface ? TemporaryConstantPool.INSTANCE.interfaceMethodRefEntry(owner, nameAndType) : TemporaryConstantPool.INSTANCE.methodRefEntry(owner, nameAndType));
    }
}

