/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Label;
import io.smallrye.classfile.TypeAnnotation;
import io.smallrye.classfile.impl.BytecodeHelpers;
import io.smallrye.classfile.impl.Util;
import java.util.List;
import java.util.Objects;

public final class TargetInfoImpl {
    private TargetInfoImpl() {
    }

    private static TypeAnnotation.TargetType checkValid(TypeAnnotation.TargetType targetType, int rangeFrom, int rangeTo) {
        if (targetType.targetTypeValue() < rangeFrom || targetType.targetTypeValue() > rangeTo) {
            throw new IllegalArgumentException("Wrong target type specified " + String.valueOf((Object)targetType));
        }
        return targetType;
    }

    public record TypeArgumentTargetImpl(TypeAnnotation.TargetType targetType, Label target, int typeArgumentIndex) implements TypeAnnotation.TypeArgumentTarget
    {
        public TypeArgumentTargetImpl {
            TargetInfoImpl.checkValid(targetType, 71, 75);
            Objects.requireNonNull(target);
            Util.checkU1(typeArgumentIndex, "type argument index");
        }
    }

    public record OffsetTargetImpl(TypeAnnotation.TargetType targetType, Label target) implements TypeAnnotation.OffsetTarget
    {
        public OffsetTargetImpl(TypeAnnotation.TargetType targetType, Label target) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 67, 70);
            this.target = Objects.requireNonNull(target);
        }
    }

    public record CatchTargetImpl(int exceptionTableIndex) implements TypeAnnotation.CatchTarget
    {
        public CatchTargetImpl {
            Util.checkU2(exceptionTableIndex, "exception table index");
        }

        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.EXCEPTION_PARAMETER;
        }
    }

    public record LocalVarTargetInfoImpl(Label startLabel, Label endLabel, int index) implements TypeAnnotation.LocalVarTargetInfo
    {
        public LocalVarTargetInfoImpl {
            Objects.requireNonNull(startLabel);
            Objects.requireNonNull(endLabel);
            BytecodeHelpers.validateSlot(index);
        }
    }

    public record LocalVarTargetImpl(TypeAnnotation.TargetType targetType, List<TypeAnnotation.LocalVarTargetInfo> table) implements TypeAnnotation.LocalVarTarget
    {
        public LocalVarTargetImpl(TypeAnnotation.TargetType targetType, List<TypeAnnotation.LocalVarTargetInfo> table) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 64, 65);
            this.table = Util.sanitizeU2List(table);
        }

        @Override
        public int size() {
            return 2 + 6 * this.table.size();
        }
    }

    public record ThrowsTargetImpl(int throwsTargetIndex) implements TypeAnnotation.ThrowsTarget
    {
        public ThrowsTargetImpl {
            Util.checkU2(throwsTargetIndex, "throws type index");
        }

        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.THROWS;
        }
    }

    public record FormalParameterTargetImpl(int formalParameterIndex) implements TypeAnnotation.FormalParameterTarget
    {
        public FormalParameterTargetImpl {
            Util.checkU1(formalParameterIndex, "formal parameter index");
        }

        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.METHOD_FORMAL_PARAMETER;
        }
    }

    public record EmptyTargetImpl(TypeAnnotation.TargetType targetType) implements TypeAnnotation.EmptyTarget
    {
        public EmptyTargetImpl(TypeAnnotation.TargetType targetType) {
            this.targetType = TargetInfoImpl.checkValid(targetType, 19, 21);
        }
    }

    public record TypeParameterBoundTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex, int boundIndex) implements TypeAnnotation.TypeParameterBoundTarget
    {
        public TypeParameterBoundTargetImpl {
            TargetInfoImpl.checkValid(targetType, 17, 18);
            Util.checkU1(typeParameterIndex, "type parameter index");
            Util.checkU1(boundIndex, "bound index");
        }
    }

    public record SupertypeTargetImpl(int supertypeIndex) implements TypeAnnotation.SupertypeTarget
    {
        public SupertypeTargetImpl {
            Util.checkU2(supertypeIndex, "supertype index");
        }

        @Override
        public TypeAnnotation.TargetType targetType() {
            return TypeAnnotation.TargetType.CLASS_EXTENDS;
        }
    }

    public record TypeParameterTargetImpl(TypeAnnotation.TargetType targetType, int typeParameterIndex) implements TypeAnnotation.TypeParameterTarget
    {
        public TypeParameterTargetImpl {
            TargetInfoImpl.checkValid(targetType, 0, 1);
            Util.checkU1(typeParameterIndex, "type parameter index");
        }
    }
}

