/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.classfile.impl;

import io.smallrye.classfile.Attribute;
import io.smallrye.classfile.ClassReader;
import io.smallrye.classfile.attribute.RecordComponentInfo;
import io.smallrye.classfile.constantpool.Utf8Entry;
import io.smallrye.classfile.impl.BoundAttribute;
import java.util.List;

public final class BoundRecordComponentInfo
implements RecordComponentInfo {
    private final ClassReader reader;
    private final int startPos;
    private final int attributesPos;
    private List<Attribute<?>> attributes;

    public BoundRecordComponentInfo(ClassReader reader, int startPos) {
        this.reader = reader;
        this.startPos = startPos;
        this.attributesPos = startPos + 4;
    }

    @Override
    public Utf8Entry name() {
        return this.reader.readEntry(this.startPos, Utf8Entry.class);
    }

    @Override
    public Utf8Entry descriptor() {
        return this.reader.readEntry(this.startPos + 2, Utf8Entry.class);
    }

    @Override
    public List<Attribute<?>> attributes() {
        if (this.attributes == null) {
            this.attributes = BoundAttribute.readAttributes(null, this.reader, this.attributesPos, this.reader.customAttributes());
        }
        return this.attributes;
    }
}

