/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.beanbag;

import io.smallrye.beanbag.BeanInstantiationException;
import io.smallrye.beanbag.BeanSupplier;
import io.smallrye.beanbag.Scope;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

final class ConstructorSupplier<T>
implements BeanSupplier<T> {
    private final Constructor<T> constructor;
    private final List<BeanSupplier<?>> argumentSuppliers;

    ConstructorSupplier(Constructor<T> constructor, List<BeanSupplier<?>> argumentSuppliers) {
        if (argumentSuppliers.size() != constructor.getParameterCount()) {
            throw new IllegalArgumentException("Not enough argument suppliers for the given constructor");
        }
        this.constructor = constructor;
        this.argumentSuppliers = argumentSuppliers;
    }

    @Override
    public T get(Scope scope) {
        int size = this.argumentSuppliers.size();
        Object[] arguments = new Object[size];
        for (int i = 0; i < size; ++i) {
            try {
                arguments[i] = this.argumentSuppliers.get(i).get(scope);
                continue;
            }
            catch (Exception ex) {
                throw new BeanInstantiationException("Failed to inject argument " + i + " of constructor for " + String.valueOf(this.constructor.getDeclaringClass()), ex);
            }
        }
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new BeanInstantiationException("Constructor usage failed", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInstantiationException("Constructor invocation failed", e.getCause());
        }
    }
}

