/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.utils;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.brackit.xquery.atomic.QNm;

public final class XMLToken {
    private static final int[] CHLEN = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 3, 4};

    private XMLToken() {
        throw new AssertionError((Object)"May never be instantiated!");
    }

    public static boolean valid(int ch) {
        return ch >= 32 && ch <= 55295 || ch == 10 || ch == 9 || ch == 13 || ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isNCStartChar(int ch) {
        return ch < 128 ? ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95 : (ch < 768 ? ch >= 192 && ch != 215 && ch != 247 : ch >= 880 && ch <= 893 || ch >= 895 && ch <= 8191 || ch >= 8204 && ch <= 8205 || ch >= 8304 && ch <= 8591 || ch >= 11264 && ch <= 12031 || ch >= 12289 && ch <= 55295 || ch >= 63744 && ch <= 64975 || ch >= 65008 && ch <= 65533 || ch >= 65536 && ch <= 983039);
    }

    public static boolean isNCChar(int ch) {
        return XMLToken.isNCStartChar(ch) || (ch < 256 ? XMLToken.digit(ch) || ch == 45 || ch == 46 || ch == 183 : ch >= 768 && ch <= 879 || ch == 8255 || ch == 8256);
    }

    public static boolean isStartChar(int ch) {
        return XMLToken.isNCStartChar(ch) || ch == 58;
    }

    public static boolean isChar(int ch) {
        return XMLToken.isNCChar(ch) || ch == 58;
    }

    public static boolean isNCName(byte[] v) {
        int l = v.length;
        return l != 0 && XMLToken.ncName(v, 0) == l;
    }

    public static boolean isName(byte[] v) {
        int l = v.length;
        for (int i = 0; i < l; i += XMLToken.cl(v, i)) {
            int c = XMLToken.cp(v, i);
            if (!(i == 0 ? !XMLToken.isStartChar(c) : !XMLToken.isChar(c))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isNMToken(byte[] v) {
        int l = v.length;
        for (int i = 0; i < l; i += XMLToken.cl(v, i)) {
            if (XMLToken.isChar(XMLToken.cp(v, i))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isQName(byte[] val) {
        int l = val.length;
        if (l == 0) {
            return false;
        }
        int i = XMLToken.ncName(val, 0);
        if (i == l) {
            return true;
        }
        if (i == 0 || val[i] != 58) {
            return false;
        }
        int j = XMLToken.ncName(val, i + 1);
        return j != i + 1 && j == l;
    }

    public static boolean isValidQName(QNm name) {
        String localPart = ((QNm)Preconditions.checkNotNull((Object)name)).getLocalName();
        if (!localPart.isEmpty() && !XMLToken.isNCName(localPart.getBytes())) {
            return false;
        }
        String prefix = name.getPrefix();
        return prefix.isEmpty() || XMLToken.isNCName(prefix.getBytes());
    }

    public static boolean isUrl(String namespaceURI) {
        try {
            new URL(namespaceURI).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return false;
        }
        return true;
    }

    public static int cp(byte[] token, int pos) {
        byte v = token[pos];
        if ((v & 0xFF) < 192) {
            return v & 0xFF;
        }
        int vl = XMLToken.cl(v);
        if (pos + vl > token.length) {
            return 65533;
        }
        if (vl == 2) {
            return (v & 0x1F) << 6 | token[pos + 1] & 0x3F;
        }
        if (vl == 3) {
            return (v & 0xF) << 12 | (token[pos + 1] & 0x3F) << 6 | token[pos + 2] & 0x3F;
        }
        return (v & 7) << 18 | (token[pos + 1] & 0x3F) << 12 | (token[pos + 2] & 0x3F) << 6 | token[pos + 3] & 0x3F;
    }

    private static int ncName(byte[] v, int p) {
        int l = v.length;
        for (int i = p; i < l; i += XMLToken.cl(v, i)) {
            int c = XMLToken.cp(v, i);
            if (!(i == p ? !XMLToken.isNCStartChar(c) : !XMLToken.isNCChar(c))) continue;
            return i;
        }
        return l;
    }

    public static int cl(byte first) {
        return first >= 0 ? 1 : CHLEN[first >> 4 & 0xF];
    }

    public static int cl(byte[] token, int pos) {
        return XMLToken.cl(token[pos]);
    }

    public static boolean digit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    public static String escapeAttribute(String value) {
        Preconditions.checkNotNull((Object)value);
        StringBuilder escape = new StringBuilder();
        block7: for (char i : value.toCharArray()) {
            switch (i) {
                case '&': {
                    escape.append("&amp;");
                    continue block7;
                }
                case '<': {
                    escape.append("&lt;");
                    continue block7;
                }
                case '>': {
                    escape.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    escape.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    escape.append("&apos;");
                    continue block7;
                }
                default: {
                    escape.append(i);
                }
            }
        }
        return escape.toString();
    }

    public static String escapeContent(String value) {
        Preconditions.checkNotNull((Object)value);
        StringBuilder escape = new StringBuilder();
        block5: for (char i : value.toCharArray()) {
            switch (i) {
                case '&': {
                    escape.append("&amp;");
                    continue block5;
                }
                case '<': {
                    escape.append("&lt;");
                    continue block5;
                }
                case '>': {
                    escape.append("&gt;");
                    continue block5;
                }
                default: {
                    escape.append(i);
                }
            }
        }
        return escape.toString();
    }
}

