/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.Set;
import org.sirix.exception.SirixIOException;

public final class SirixFiles {
    private SirixFiles() {
        throw new AssertionError((Object)"May not be instantiated!");
    }

    public static void recursiveRemove(Path path, Set<FileVisitOption> options) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                Files.walkFileTree((Path)Preconditions.checkNotNull((Object)path), (Set)Preconditions.checkNotNull(options), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (exc == null) {
                            Files.delete(dir);
                            return FileVisitResult.CONTINUE;
                        }
                        throw exc;
                    }
                });
            }
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    public static void recursiveRemove(Path path) {
        SirixFiles.recursiveRemove(path, EnumSet.noneOf(FileVisitOption.class));
    }
}

