/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.utils;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;

public final class LogWrapper {
    private final Logger mLogger;

    public LogWrapper(Logger pLogger) {
        this.mLogger = (Logger)Preconditions.checkNotNull((Object)pLogger);
    }

    public void error(String pMessage, Object ... pObjects) {
        if (this.mLogger.isErrorEnabled()) {
            this.mLogger.error(pMessage, pObjects);
        }
    }

    public void error(Exception pExc) {
        if (this.mLogger.isErrorEnabled()) {
            this.mLogger.error(pExc.getMessage(), (Throwable)pExc);
        }
    }

    public void debug(String pMessage, Object ... pObjects) {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug(pMessage, pObjects);
        }
    }

    public void info(String pMessage, Object ... pObjects) {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info(pMessage, pObjects);
        }
    }

    public void warn(String pMessage, Object ... pObjects) {
        if (this.mLogger.isWarnEnabled()) {
            this.mLogger.warn(pMessage, pObjects);
        }
    }
}

