/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.settings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnegative;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.PageContainer;
import org.sirix.node.interfaces.Record;
import org.sirix.page.PageReference;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;

public enum VersioningType {
    FULL{

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> T combineRecordPages(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() == 1) : "Only one version of the page!";
            return (T)((KeyValuePage)pages.get(0));
        }

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer combineRecordPagesForModification(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference) {
            assert (pages.size() == 1);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            ArrayList returnVal = new ArrayList(2);
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            for (Map.Entry entry : ((KeyValuePage)pages.get(0)).entrySet()) {
                ((KeyValuePage)returnVal.get(0)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
                ((KeyValuePage)returnVal.get(1)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
            }
            return PageContainer.getInstance((Page)returnVal.get(0), (Page)returnVal.get(1));
        }

        @Override
        public int[] getRevisionRoots(@Nonnegative int previousRevision, @Nonnegative int revsToRestore) {
            return new int[]{previousRevision};
        }
    }
    ,
    DIFFERENTIAL{

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> T combineRecordPages(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            KeyValuePage fullDump;
            assert (pages.size() <= 2);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object returnVal = firstPage.newInstance(recordPageKey, firstPage.getPageKind(), firstPage.getPreviousReferenceKey(), pageReadTrx);
            KeyValuePage latest = (KeyValuePage)pages.get(0);
            KeyValuePage keyValuePage = fullDump = pages.size() == 1 ? (KeyValuePage)pages.get(0) : (KeyValuePage)pages.get(1);
            assert (latest.getPageKey() == recordPageKey);
            assert (fullDump.getPageKey() == recordPageKey);
            for (Map.Entry entry : latest.entrySet()) {
                returnVal.setEntry((Comparable)((Comparable)entry.getKey()), (Record)((Record)entry.getValue()));
            }
            for (Map.Entry entry : latest.referenceEntrySet()) {
                returnVal.setPageReference((Comparable)((Comparable)entry.getKey()), (PageReference)entry.getValue());
            }
            if (pages.size() == 2) {
                for (Map.Entry entry : fullDump.entrySet()) {
                    if (returnVal.getValue((Comparable)((Comparable)entry.getKey())) != null) continue;
                    returnVal.setEntry((Comparable)((Comparable)entry.getKey()), (Record)((Record)entry.getValue()));
                    if (returnVal.size() != 512) continue;
                    break;
                }
                for (Map.Entry entry : fullDump.referenceEntrySet()) {
                    if (returnVal.getPageReference((Comparable)((Comparable)entry.getKey())) != null) continue;
                    returnVal.setPageReference((Comparable)((Comparable)entry.getKey()), (PageReference)entry.getValue());
                    if (returnVal.size() != 512) continue;
                    break;
                }
            }
            return (T)returnVal;
        }

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer combineRecordPagesForModification(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference) {
            assert (pages.size() <= 2);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            int revision = pageReadTrx.getUberPage().getRevision();
            ArrayList returnVal = new ArrayList(2);
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            KeyValuePage latest = firstPage;
            KeyValuePage fullDump = pages.size() == 1 ? firstPage : (KeyValuePage)pages.get(1);
            boolean isFullDump = revision % revToRestore == 0;
            for (Map.Entry entry : latest.entrySet()) {
                ((KeyValuePage)returnVal.get(0)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
                ((KeyValuePage)returnVal.get(1)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
            }
            for (Map.Entry entry : latest.referenceEntrySet()) {
                ((KeyValuePage)returnVal.get(0)).setPageReference((Comparable)entry.getKey(), (PageReference)entry.getValue());
                ((KeyValuePage)returnVal.get(1)).setPageReference((Comparable)entry.getKey(), (PageReference)entry.getValue());
            }
            if (latest.size() != 512) {
                for (Map.Entry entry : fullDump.entrySet()) {
                    if (((KeyValuePage)returnVal.get(0)).getValue((Comparable)entry.getKey()) == null) {
                        ((KeyValuePage)returnVal.get(0)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
                    }
                    if (isFullDump && ((KeyValuePage)returnVal.get(1)).getValue((Comparable)entry.getKey()) == null) {
                        ((KeyValuePage)returnVal.get(1)).setEntry((Comparable)entry.getKey(), (Record)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    break;
                }
            }
            if (latest.size() != 512) {
                for (Map.Entry entry : fullDump.referenceEntrySet()) {
                    if (((KeyValuePage)returnVal.get(0)).getPageReference((Comparable)entry.getKey()) == null) {
                        ((KeyValuePage)returnVal.get(0)).setPageReference((Comparable)entry.getKey(), (PageReference)entry.getValue());
                    }
                    if (isFullDump && ((KeyValuePage)returnVal.get(1)).getPageReference((Comparable)entry.getKey()) == null) {
                        ((KeyValuePage)returnVal.get(1)).setPageReference((Comparable)entry.getKey(), (PageReference)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    break;
                }
            }
            return PageContainer.getInstance((Page)returnVal.get(0), (Page)returnVal.get(1));
        }

        @Override
        public int[] getRevisionRoots(@Nonnegative int previousRevision, @Nonnegative int revsToRestore) {
            int revisionsToRestore = previousRevision % revsToRestore;
            int lastFullDump = previousRevision - revisionsToRestore;
            if (lastFullDump == previousRevision) {
                return new int[]{lastFullDump};
            }
            return new int[]{previousRevision, lastFullDump};
        }
    }
    ,
    INCREMENTAL{

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> T combineRecordPages(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() <= revToRestore);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object returnVal = firstPage.newInstance(firstPage.getPageKey(), firstPage.getPageKind(), firstPage.getPreviousReferenceKey(), firstPage.getPageReadTrx());
            boolean filledPage = false;
            block0: for (KeyValuePage page : pages) {
                Comparable recordKey;
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                for (Map.Entry entry : page.entrySet()) {
                    recordKey = (Comparable)entry.getKey();
                    if (returnVal.getValue((Comparable)recordKey) != null) continue;
                    returnVal.setEntry((Comparable)recordKey, (Record)((Record)entry.getValue()));
                    if (returnVal.size() != 512) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry entry : page.referenceEntrySet()) {
                    recordKey = (Comparable)entry.getKey();
                    if (returnVal.getPageReference((Comparable)recordKey) != null) continue;
                    returnVal.setPageReference((Comparable)recordKey, (PageReference)entry.getValue());
                    if (returnVal.size() != 512) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return (T)returnVal;
        }

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer combineRecordPagesForModification(List<T> pages, int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference) {
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            ArrayList returnVal = new ArrayList(2);
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            boolean isFullDump = pages.size() == revToRestore;
            boolean filledPage = false;
            block0: for (KeyValuePage page : pages) {
                Comparable key;
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                for (Map.Entry entry : page.entrySet()) {
                    key = (Comparable)entry.getKey();
                    assert (key != null);
                    if (entry == null || ((KeyValuePage)returnVal.get(0)).getValue(key) != null) continue;
                    ((KeyValuePage)returnVal.get(0)).setEntry(key, (Record)entry.getValue());
                    if (((KeyValuePage)returnVal.get(1)).getValue((Comparable)entry.getKey()) == null && isFullDump) {
                        ((KeyValuePage)returnVal.get(1)).setEntry(key, (Record)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry entry : page.referenceEntrySet()) {
                    key = (Comparable)entry.getKey();
                    assert (key != null);
                    if (entry == null || ((KeyValuePage)returnVal.get(0)).getPageReference(key) != null) continue;
                    ((KeyValuePage)returnVal.get(0)).setPageReference(key, (PageReference)entry.getValue());
                    if (((KeyValuePage)returnVal.get(1)).getPageReference((Comparable)entry.getKey()) == null && isFullDump) {
                        ((KeyValuePage)returnVal.get(1)).setPageReference(key, (PageReference)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return PageContainer.getInstance((Page)returnVal.get(0), (Page)returnVal.get(1));
        }

        @Override
        public int[] getRevisionRoots(@Nonnegative int previousRevision, @Nonnegative int revsToRestore) {
            ArrayList<Integer> retVal = new ArrayList<Integer>(revsToRestore);
            int until = previousRevision - revsToRestore;
            for (int i = previousRevision; i > until && i >= 0; --i) {
                retVal.add(i);
            }
            assert (retVal.size() <= revsToRestore);
            return this.convertIntegers(retVal);
        }

        private int[] convertIntegers(List<Integer> integers) {
            int[] retVal = new int[integers.size()];
            Iterator<Integer> iterator = integers.iterator();
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = iterator.next();
            }
            return retVal;
        }
    }
    ,
    SLIDING_SNAPSHOT{

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> T combineRecordPages(List<T> pages, @Nonnegative int revToRestore, PageReadOnlyTrx pageReadTrx) {
            assert (pages.size() <= revToRestore);
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            Object returnVal = firstPage.newInstance(firstPage.getPageKey(), firstPage.getPageKind(), firstPage.getPreviousReferenceKey(), firstPage.getPageReadTrx());
            boolean filledPage = false;
            block0: for (int i = 0; i < pages.size(); ++i) {
                Comparable recordKey;
                KeyValuePage page = (KeyValuePage)pages.get(i);
                assert (page.getPageKey() == recordPageKey);
                if (filledPage) break;
                for (Map.Entry entry : page.entrySet()) {
                    recordKey = (Comparable)entry.getKey();
                    if (returnVal.getValue((Comparable)recordKey) != null) continue;
                    returnVal.setEntry((Comparable)recordKey, (Record)((Record)entry.getValue()));
                    if (returnVal.size() != 512) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry entry : page.referenceEntrySet()) {
                    recordKey = (Comparable)entry.getKey();
                    if (returnVal.getPageReference((Comparable)recordKey) != null) continue;
                    returnVal.setPageReference((Comparable)recordKey, (PageReference)entry.getValue());
                    if (returnVal.size() != 512) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return (T)returnVal;
        }

        @Override
        public <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer combineRecordPagesForModification(List<T> pages, int revToRestore, PageReadOnlyTrx pageReadTrx, PageReference reference) {
            KeyValuePage firstPage = (KeyValuePage)pages.get(0);
            long recordPageKey = firstPage.getPageKey();
            ArrayList returnVal = new ArrayList(2);
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            returnVal.add(firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx));
            Object reconstructed = firstPage.newInstance(recordPageKey, firstPage.getPageKind(), reference.getKey(), pageReadTrx);
            boolean filledPage = false;
            block0: for (int i = 0; i < pages.size() && !filledPage; ++i) {
                Comparable key;
                KeyValuePage page = (KeyValuePage)pages.get(i);
                assert (page.getPageKey() == recordPageKey);
                boolean pageToSerialize = i == pages.size() - 1 && revToRestore == pages.size();
                for (Map.Entry entry : page.entrySet()) {
                    key = (Comparable)entry.getKey();
                    assert (key != null);
                    if (!pageToSerialize) {
                        reconstructed.setEntry((Comparable)key, (Record)((Record)entry.getValue()));
                    }
                    if (((KeyValuePage)returnVal.get(0)).getValue(key) == null) {
                        ((KeyValuePage)returnVal.get(0)).setEntry(key, (Record)entry.getValue());
                    }
                    if (pageToSerialize && reconstructed.getValue((Comparable)key) == null) {
                        ((KeyValuePage)returnVal.get(1)).setEntry(key, (Record)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    filledPage = true;
                    break;
                }
                if (filledPage) continue;
                for (Map.Entry entry : page.referenceEntrySet()) {
                    key = (Comparable)entry.getKey();
                    assert (key != null);
                    if (!pageToSerialize) {
                        reconstructed.setPageReference((Comparable)key, (PageReference)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).getPageReference(key) == null) {
                        ((KeyValuePage)returnVal.get(0)).setPageReference(key, (PageReference)entry.getValue());
                    }
                    if (pageToSerialize && reconstructed.getPageReference((Comparable)key) == null) {
                        ((KeyValuePage)returnVal.get(1)).setPageReference(key, (PageReference)entry.getValue());
                    }
                    if (((KeyValuePage)returnVal.get(0)).size() != 512) continue;
                    filledPage = true;
                    continue block0;
                }
            }
            return PageContainer.getInstance((Page)returnVal.get(0), (Page)returnVal.get(1));
        }

        @Override
        public int[] getRevisionRoots(@Nonnegative int previousRevision, @Nonnegative int revsToRestore) {
            ArrayList<Integer> retVal = new ArrayList<Integer>(revsToRestore);
            int until = previousRevision - revsToRestore;
            for (int i = previousRevision; i > until && i >= 0; --i) {
                retVal.add(i);
            }
            assert (retVal.size() <= revsToRestore);
            return this.convertIntegers(retVal);
        }

        private int[] convertIntegers(List<Integer> integers) {
            int[] retVal = new int[integers.size()];
            Iterator<Integer> iterator = integers.iterator();
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = iterator.next();
            }
            return retVal;
        }
    };


    public abstract <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> T combineRecordPages(List<T> var1, @Nonnegative int var2, PageReadOnlyTrx var3);

    public abstract <K extends Comparable<? super K>, V extends Record, T extends KeyValuePage<K, V>> PageContainer combineRecordPagesForModification(List<T> var1, @Nonnegative int var2, PageReadOnlyTrx var3, PageReference var4);

    public abstract int[] getRevisionRoots(@Nonnegative int var1, @Nonnegative int var2);
}

