/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.settings;

import org.sirix.settings.Constants;

public enum CharsForSerializing {
    SPACE(new byte[][]{{32}}),
    OPEN(new byte[][]{{60}}),
    CLOSE(new byte[][]{{62}}),
    SLASH(new byte[][]{{47}}),
    EQUAL(new byte[][]{{61}}),
    QUOTE(new byte[][]{{34}}),
    EQUAL_QUOTE(EQUAL.getBytes(), QUOTE.getBytes()),
    OPEN_SLASH(OPEN.getBytes(), SLASH.getBytes()),
    SLASH_CLOSE(SLASH.getBytes(), CLOSE.getBytes()),
    REST_PREFIX(SPACE.getBytes(), {114, 101, 115, 116, 58}),
    SID_PREFIX(SPACE.getBytes(), {115, 100, 98, 58}),
    ID(new byte[][]{{105, 100}}),
    XMLNS(SPACE.getBytes(), {120, 109, 108, 110, 115}, EQUAL.getBytes(), QUOTE.getBytes()),
    COLON(new byte[][]{{58}}),
    XMLNS_COLON(SPACE.getBytes(), {120, 109, 108, 110, 115, 58}),
    OPENCOMMENT(OPEN.getBytes(), {33, 45, 45}, SPACE.getBytes()),
    CLOSECOMMENT(SPACE.getBytes(), {45, 45}, CLOSE.getBytes()),
    OPENPI(OPEN.getBytes(), {63}),
    CLOSEPI({63}, CLOSE.getBytes()),
    NEWLINE(new byte[][]{System.getProperty("line.separator").getBytes(Constants.DEFAULT_ENCODING)});

    private final byte[] mBytes;

    private CharsForSerializing(byte[] ... bytes) {
        int index = 0;
        for (byte[] runner : bytes) {
            index += runner.length;
        }
        this.mBytes = new byte[index];
        index = 0;
        for (byte[] runner : bytes) {
            System.arraycopy(runner, 0, this.mBytes, index, runner.length);
            index += runner.length;
        }
    }

    public byte[] getBytes() {
        return this.mBytes;
    }
}

