/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.operators;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.interfaces.Node;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.XPathError;
import org.sirix.service.xml.xpath.operators.AbstractObAxis;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.utils.TypedValue;

public class MulOpAxis
extends AbstractObAxis {
    public MulOpAxis(XmlNodeReadOnlyTrx rtx, Axis mOp1, Axis mOp2) {
        super(rtx, mOp1, mOp2);
    }

    @Override
    public Node operate(AtomicValue mOperand1, AtomicValue mOperand2) throws SirixXPathException {
        byte[] value;
        Type returnType = this.getReturnType(mOperand1.getTypeKey(), mOperand2.getTypeKey());
        int typeKey = this.asXdmNodeReadTrx().keyForName(returnType.getStringRepr());
        switch (returnType) {
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case INTEGER: {
                double dOp1 = Double.parseDouble(new String(mOperand1.getRawValue()));
                double dOp2 = Double.parseDouble(new String(mOperand2.getRawValue()));
                value = TypedValue.getBytes(dOp1 * dOp2);
                break;
            }
            case YEAR_MONTH_DURATION: 
            case DAY_TIME_DURATION: {
                throw new IllegalStateException("Add operator is not implemented for the type " + returnType.getStringRepr() + " yet.");
            }
            default: {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
        }
        return new AtomicValue(value, typeKey);
    }

    @Override
    protected Type getReturnType(int mOp1, int mOp2) throws SirixXPathException {
        Type type2;
        Type type1;
        try {
            type1 = Type.getType(mOp1).getPrimitiveBaseType();
            type2 = Type.getType(mOp2).getPrimitiveBaseType();
        }
        catch (IllegalStateException e) {
            throw new XPathError(XPathError.ErrorType.XPTY0004);
        }
        if (type1.isNumericType() && type2.isNumericType()) {
            if (type1 == type2) {
                return type1;
            }
            if (type1 == Type.DOUBLE || type2 == Type.DOUBLE) {
                return Type.DOUBLE;
            }
            if (type1 == Type.FLOAT || type2 == Type.FLOAT) {
                return Type.FLOAT;
            }
            assert (type1 == Type.DECIMAL || type2 == Type.DECIMAL);
            return Type.DECIMAL;
        }
        switch (type1) {
            case YEAR_MONTH_DURATION: {
                if (!type2.isNumericType()) break;
                return type1;
            }
            case DAY_TIME_DURATION: {
                if (!type2.isNumericType()) break;
                return type1;
            }
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case INTEGER: {
                if (type2 != Type.DAY_TIME_DURATION && type2 != Type.YEAR_MONTH_DURATION) break;
                return type2;
            }
            default: {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
        }
        throw new XPathError(XPathError.ErrorType.XPTY0004);
    }
}

