/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.operators;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.interfaces.Node;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.EXPathError;
import org.sirix.service.xml.xpath.operators.AbstractObAxis;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.utils.TypedValue;

public class AddOpAxis
extends AbstractObAxis {
    public AddOpAxis(XmlNodeReadOnlyTrx rtx, Axis mOp1, Axis mOp2) {
        super(rtx, mOp1, mOp2);
    }

    @Override
    public Node operate(AtomicValue mOperand1, AtomicValue mOperand2) throws SirixXPathException {
        byte[] value;
        Type returnType = this.getReturnType(mOperand1.getTypeKey(), mOperand2.getTypeKey());
        int typeKey = this.asXdmNodeReadTrx().keyForName(returnType.getStringRepr());
        switch (returnType) {
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: 
            case INTEGER: {
                double dOp1 = Double.parseDouble(new String(mOperand1.getRawValue()));
                double dOp2 = Double.parseDouble(new String(mOperand2.getRawValue()));
                value = TypedValue.getBytes(dOp1 + dOp2);
                break;
            }
            case DATE: 
            case TIME: 
            case DATE_TIME: 
            case YEAR_MONTH_DURATION: 
            case DAY_TIME_DURATION: {
                throw new IllegalStateException("Add operator is not implemented for the type " + returnType.getStringRepr() + " yet.");
            }
            default: {
                throw EXPathError.XPTY0004.getEncapsulatedException();
            }
        }
        return new AtomicValue(value, typeKey);
    }

    @Override
    protected Type getReturnType(int mOp1, int mOp2) throws SirixXPathException {
        Type mType1 = Type.getType(mOp1).getPrimitiveBaseType();
        Type mType2 = Type.getType(mOp2).getPrimitiveBaseType();
        if (mType1.isNumericType() && mType2.isNumericType()) {
            if (mType1 == mType2) {
                return mType1;
            }
            if (mType1 == Type.DOUBLE || mType2 == Type.DOUBLE) {
                return Type.DOUBLE;
            }
            if (mType1 == Type.FLOAT || mType2 == Type.FLOAT) {
                return Type.FLOAT;
            }
            assert (mType1 == Type.DECIMAL || mType2 == Type.DECIMAL);
            return Type.DECIMAL;
        }
        switch (mType1) {
            case DATE: {
                if (mType2 != Type.YEAR_MONTH_DURATION && mType2 != Type.DAY_TIME_DURATION) break;
                return mType1;
            }
            case TIME: {
                if (mType2 != Type.DAY_TIME_DURATION) break;
                return mType1;
            }
            case DATE_TIME: {
                if (mType2 != Type.YEAR_MONTH_DURATION && mType2 != Type.DAY_TIME_DURATION) break;
                return mType1;
            }
            case YEAR_MONTH_DURATION: {
                if (mType2 != Type.DATE && mType2 != Type.DATE_TIME && mType2 != Type.YEAR_MONTH_DURATION) break;
                return mType2;
            }
            case DAY_TIME_DURATION: {
                if (mType2 != Type.DATE && mType2 != Type.TIME && mType2 != Type.DATE_TIME && mType2 != Type.DAY_TIME_DURATION) break;
                return mType2;
            }
            default: {
                throw EXPathError.XPTY0004.getEncapsulatedException();
            }
        }
        throw EXPathError.XPTY0004.getEncapsulatedException();
    }
}

