/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.functions;

import java.util.ArrayList;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.Kind;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.EXPathError;
import org.sirix.service.xml.xpath.functions.FuncDef;
import org.sirix.service.xml.xpath.functions.sequences.FNBoolean;
import org.sirix.service.xml.xpath.types.Type;

public class Function {
    public static boolean ebv(Axis axis) throws SirixXPathException {
        FuncDef ebv = FuncDef.BOOLEAN;
        ArrayList<Axis> param = new ArrayList<Axis>();
        param.add(axis);
        FNBoolean bAxis = new FNBoolean(axis.asXdmNodeReadTrx(), param, ebv.getMin(), ebv.getMax(), axis.asXdmNodeReadTrx().keyForName(ebv.getReturnType()));
        if (((AbstractAxis)bAxis).hasNext()) {
            bAxis.next();
            boolean result = Boolean.parseBoolean(bAxis.asXdmNodeReadTrx().getValue());
            if (!((AbstractAxis)bAxis).hasNext()) {
                ((AbstractAxis)bAxis).reset(axis.asXdmNodeReadTrx().getNodeKey());
                return result;
            }
        }
        throw new IllegalStateException("This should not happen!");
    }

    public static boolean empty(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        boolean result = !axis.hasNext();
        int itemKey = rtx.getItemList().addItem(new AtomicValue(result));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean exactlyOne(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) throws SirixXPathException {
        if (axis.hasNext()) {
            if (axis.hasNext()) {
                throw EXPathError.FORG0005.getEncapsulatedException();
            }
        } else {
            throw EXPathError.FORG0005.getEncapsulatedException();
        }
        int itemKey = rtx.getItemList().addItem(new AtomicValue(true));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean exists(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        boolean result = axis.hasNext();
        int itemKey = rtx.getItemList().addItem(new AtomicValue(result));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean fnBoolean(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) throws SirixXPathException {
        boolean ebv = Function.ebv(axis);
        int itemKey = rtx.getItemList().addItem(new AtomicValue(ebv));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean fnData(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        if (axis.hasNext()) {
            if (rtx.getNodeKey() >= 0L) {
                int itemKey = rtx.getItemList().addItem(new AtomicValue(rtx.getValue().getBytes(), rtx.getTypeKey()));
                rtx.moveTo(itemKey);
                return true;
            }
            return true;
        }
        return false;
    }

    public static boolean fnNilled(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        if (axis.hasNext() && rtx.getKind() == Kind.ELEMENT) {
            boolean nilled = false;
            int itemKey = rtx.getItemList().addItem(new AtomicValue(false));
            rtx.moveTo(itemKey);
            return true;
        }
        return false;
    }

    public static boolean fnNodeName(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        String name;
        if (axis.hasNext() && !(name = rtx.getName().getLocalName()).equals("-1")) {
            int itemKey = rtx.getItemList().addItem(new AtomicValue(name, Type.STRING));
            rtx.moveTo(itemKey);
            return true;
        }
        return false;
    }

    public static boolean fnnot(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        if (axis.hasNext()) {
            axis.next();
            AtomicValue item = new AtomicValue(rtx.getRawValue()[0] == 0);
            int itemKey = rtx.getItemList().addItem(item);
            rtx.moveTo(itemKey);
            return true;
        }
        return false;
    }

    public static boolean fnnumber(XmlNodeReadOnlyTrx rtx) {
        AtomicValue item = new AtomicValue(rtx.getValue().getBytes(), rtx.keyForName("xs:double"));
        int itemKey = rtx.getItemList().addItem(item);
        rtx.moveTo(itemKey);
        return true;
    }

    public static AtomicValue not(AtomicValue mValue) {
        return new AtomicValue(!Boolean.parseBoolean(new String(mValue.getRawValue())));
    }

    public static boolean oneOrMore(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) throws SirixXPathException {
        if (!axis.hasNext()) {
            throw EXPathError.FORG0004.getEncapsulatedException();
        }
        int itemKey = rtx.getItemList().addItem(new AtomicValue(true));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean sum(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) {
        Double value = 0.0;
        while (axis.hasNext()) {
            value = value + Double.parseDouble(rtx.getValue());
        }
        int itemKey = rtx.getItemList().addItem(new AtomicValue(value, Type.DOUBLE));
        rtx.moveTo(itemKey);
        return true;
    }

    public static boolean sum(XmlNodeReadOnlyTrx rtx, AbstractAxis axis, AbstractAxis mZero) {
        Double value = 0.0;
        if (!axis.hasNext()) {
            mZero.hasNext();
        } else {
            do {
                value = value + Double.parseDouble(rtx.getValue());
            } while (axis.hasNext());
            int itemKey = rtx.getItemList().addItem(new AtomicValue(value, Type.DOUBLE));
            rtx.moveTo(itemKey);
        }
        return true;
    }

    public static boolean zeroOrOne(XmlNodeReadOnlyTrx rtx, AbstractAxis axis) throws SirixXPathException {
        boolean result = true;
        if (axis.hasNext() && axis.hasNext()) {
            throw EXPathError.FORG0003.getEncapsulatedException();
        }
        int itemKey = rtx.getItemList().addItem(new AtomicValue(true));
        rtx.moveTo(itemKey);
        return true;
    }
}

