/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.functions;

import java.util.List;
import org.sirix.api.Axis;
import org.sirix.api.Filter;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.filter.FilterAxis;
import org.sirix.axis.filter.xml.TextFilter;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.Kind;
import org.sirix.service.xml.xpath.functions.AbstractFunction;
import org.sirix.utils.TypedValue;

public class FNString
extends AbstractFunction {
    public FNString(XmlNodeReadOnlyTrx rtx, List<Axis> args, int min, int max, int returnType) throws SirixXPathException {
        super(rtx, args, min, max, returnType);
    }

    @Override
    protected byte[] computeResult() {
        String value;
        if (this.getArgs().size() == 0) {
            value = this.getStrValue();
        } else {
            Axis axis = this.getArgs().get(0);
            StringBuilder val = new StringBuilder();
            while (axis.hasNext()) {
                axis.next();
                String nodeValue = this.getStrValue();
                if (nodeValue.equals("")) continue;
                if (val.length() > 0) {
                    val.append(" ");
                }
                val.append(nodeValue);
            }
            value = val.toString();
        }
        return TypedValue.getBytes(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getStrValue() {
        StringBuilder value = new StringBuilder();
        if (this.asXdmNodeReadTrx().getNodeKey() >= 0L) {
            if (this.asXdmNodeReadTrx().getKind() == Kind.ATTRIBUTE || this.asXdmNodeReadTrx().getKind() == Kind.TEXT) {
                value.append(this.asXdmNodeReadTrx().getValue());
                return value.toString();
            } else {
                if (this.asXdmNodeReadTrx().getKind() != Kind.XDM_DOCUMENT && this.asXdmNodeReadTrx().getKind() != Kind.ELEMENT) throw new IllegalStateException();
                FilterAxis<XmlNodeReadOnlyTrx> axis = new FilterAxis<XmlNodeReadOnlyTrx>(new DescendantAxis(this.asXdmNodeReadTrx()), new TextFilter(this.asXdmNodeReadTrx()), new Filter[0]);
                while (axis.hasNext()) {
                    axis.next();
                    if (value.length() > 0) {
                        value.append(" ");
                    }
                    value.append(this.asXdmNodeReadTrx().getValue());
                }
            }
            return value.toString();
        } else {
            value.append(this.asXdmNodeReadTrx().getValue());
        }
        return value.toString();
    }
}

