/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.expr;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.XPathError;

public class UnionAxis
extends AbstractAxis {
    private final Axis mOp1;
    private final Axis mOp2;

    public UnionAxis(XmlNodeReadOnlyTrx rtx, @Nonnull Axis operand1, @Nonnull Axis operand2) {
        super(rtx);
        this.mOp1 = (Axis)Preconditions.checkNotNull((Object)operand1);
        this.mOp2 = (Axis)Preconditions.checkNotNull((Object)operand2);
    }

    @Override
    public void reset(long nodeKey) {
        super.reset(nodeKey);
        if (this.mOp1 != null) {
            this.mOp1.reset(nodeKey);
        }
        if (this.mOp2 != null) {
            this.mOp2.reset(nodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        if (this.mOp1.hasNext()) {
            this.mKey = (Long)this.mOp1.next();
            if (this.asXdmNodeReadTrx().getNodeKey() < 0L) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
            return true;
        }
        if (this.mOp2.hasNext()) {
            this.mKey = (Long)this.mOp2.next();
            if (this.asXdmNodeReadTrx().getNodeKey() < 0L) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
            return true;
        }
        return false;
    }
}

