/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.expr;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.utils.TypedValue;

public class RangeAxis
extends AbstractAxis {
    private final Axis mFrom;
    private final Axis mTo;
    private boolean mFirst;
    private int mStart;
    private int mEnd;

    public RangeAxis(XmlNodeReadOnlyTrx rtx, Axis mFrom, Axis mTo) {
        super(rtx);
        this.mFrom = mFrom;
        this.mTo = mTo;
        this.mFirst = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean hasNext() {
        block5: {
            this.resetToLastKey();
            if (this.mFirst) {
                this.mFirst = false;
                if (this.mFrom.hasNext() && Type.getType(this.mFrom.asXdmNodeReadTrx().getTypeKey()).derivesFrom(Type.INTEGER)) {
                    this.mStart = Integer.parseInt(this.mFrom.asXdmNodeReadTrx().getValue());
                    if (this.mTo.hasNext() && Type.getType(this.mTo.asXdmNodeReadTrx().getTypeKey()).derivesFrom(Type.INTEGER)) {
                        this.mEnd = Integer.parseInt(this.mTo.asXdmNodeReadTrx().getValue());
                        break block5;
                    } else {
                        this.resetToStartKey();
                        return false;
                    }
                }
                this.resetToStartKey();
                return false;
            }
        }
        if (this.mStart <= this.mEnd) {
            int itemKey = this.asXdmNodeReadTrx().getItemList().addItem(new AtomicValue(TypedValue.getBytes(Integer.toString(this.mStart)), this.asXdmNodeReadTrx().keyForName("xs:integer")));
            this.mKey = itemKey;
            ++this.mStart;
            return true;
        }
        this.resetToStartKey();
        return false;
    }
}

