/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.comparators;

import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.comparators.CompKind;
import org.sirix.service.xml.xpath.comparators.GeneralComp;
import org.sirix.service.xml.xpath.comparators.NodeComp;
import org.sirix.service.xml.xpath.comparators.ValueComp;
import org.sirix.service.xml.xpath.expr.LiteralExpr;
import org.sirix.service.xml.xpath.types.Type;

public abstract class AbstractComparator
extends AbstractAxis {
    private final CompKind mComp;
    private final Axis mOperand1;
    private final Axis mOperand2;
    private boolean mIsFirst;

    public AbstractComparator(XmlNodeReadOnlyTrx mRtx, Axis mOperand1, Axis mOperand2, CompKind mComp) {
        super(mRtx);
        this.mComp = mComp;
        this.mOperand1 = mOperand1;
        this.mOperand2 = mOperand2;
        this.mIsFirst = true;
    }

    @Override
    public final void reset(long mNodeKey) {
        super.reset(mNodeKey);
        this.mIsFirst = true;
        if (this.mOperand1 != null) {
            this.mOperand1.reset(mNodeKey);
        }
        if (this.mOperand2 != null) {
            this.mOperand2.reset(mNodeKey);
        }
    }

    @Override
    public final boolean hasNext() {
        block8: {
            this.resetToLastKey();
            if (this.mIsFirst) {
                this.mIsFirst = false;
                if (!(this.mOperand1 instanceof LiteralExpr)) {
                    this.mOperand1.reset(this.asXdmNodeReadTrx().getNodeKey());
                }
                if (!(this.mOperand2 instanceof LiteralExpr)) {
                    this.mOperand2.reset(this.asXdmNodeReadTrx().getNodeKey());
                }
                if (this.mOperand1.hasNext()) {
                    this.mKey = (Long)this.mOperand1.next();
                    try {
                        AtomicValue[] operandOne = this.atomize(this.mOperand1);
                        if (!this.mOperand2.hasNext()) break block8;
                        this.mKey = (Long)this.mOperand2.next();
                        AtomicValue[] operandTwo = this.atomize(this.mOperand2);
                        this.hook(operandOne, operandTwo);
                        try {
                            boolean resultValue = this.compare(operandOne, operandTwo);
                            AtomicValue result = new AtomicValue(resultValue);
                            int itemKey = this.asXdmNodeReadTrx().getItemList().addItem(result);
                            this.mKey = itemKey;
                        }
                        catch (SirixXPathException e) {
                            throw new RuntimeException(e);
                        }
                        return true;
                    }
                    catch (SirixXPathException exc) {
                        throw new RuntimeException(exc);
                    }
                }
            }
        }
        this.resetToStartKey();
        return false;
    }

    protected void hook(AtomicValue[] paramOperandOne, AtomicValue[] paramOperandTwo) {
    }

    protected abstract boolean compare(AtomicValue[] var1, AtomicValue[] var2) throws SirixXPathException;

    protected abstract AtomicValue[] atomize(Axis var1) throws SirixXPathException;

    protected abstract Type getType(int var1, int var2) throws SirixXPathException;

    public final CompKind getCompKind() {
        return this.mComp;
    }

    public static final AbstractComparator getComparator(XmlNodeReadOnlyTrx paramRtx, Axis paramOperandOne, Axis paramOperandTwo, CompKind paramKind, String paramVal) {
        if ("eq".equals(paramVal) || "lt".equals(paramVal) || "le".equals(paramVal) || "gt".equals(paramVal) || "ge".equals(paramVal)) {
            return new ValueComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        if ("=".equals(paramVal) || "!=".equals(paramVal) || "<".equals(paramVal) || "<=".equals(paramVal) || ">".equals(paramVal) || ">=".equals(paramVal)) {
            return new GeneralComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        if ("is".equals(paramVal) || "<<".equals(paramVal) || ">>".equals(paramVal)) {
            new NodeComp(paramRtx, paramOperandOne, paramOperandTwo, paramKind);
        }
        throw new IllegalStateException(paramVal + " is not a valid comparison.");
    }
}

