/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnegative;
import org.sirix.api.Axis;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.IncludeSelf;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.settings.Fixed;

public abstract class AbstractAxis
implements Axis {
    private final NodeCursor mRtx;
    protected long mKey;
    private boolean mNext;
    private long mStartKey;
    private final IncludeSelf mIncludeSelf;
    private boolean mHasNext;

    public AbstractAxis(NodeCursor rtx) {
        this.mRtx = (NodeCursor)Preconditions.checkNotNull((Object)rtx);
        this.mIncludeSelf = IncludeSelf.NO;
        this.mHasNext = true;
        this.reset(rtx.getNodeKey());
    }

    public AbstractAxis(NodeCursor pRtx, IncludeSelf pIncludeSelf) {
        this.mRtx = (NodeCursor)Preconditions.checkNotNull((Object)pRtx);
        this.mIncludeSelf = (IncludeSelf)((Object)Preconditions.checkNotNull((Object)((Object)pIncludeSelf)));
        this.mHasNext = true;
        this.reset(pRtx.getNodeKey());
    }

    @Override
    public final Iterator<Long> iterator() {
        return this;
    }

    protected long done() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    public boolean hasNext() {
        if (!this.isHasNext()) {
            return false;
        }
        if (this.isNext()) {
            return true;
        }
        this.resetToLastKey();
        this.mKey = this.nextKey();
        if (this.mKey == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            this.resetToStartKey();
            return false;
        }
        return true;
    }

    protected long nextKey() {
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Long next() {
        if (!this.mHasNext) {
            throw new NoSuchElementException("No more nodes in the axis!");
        }
        if (!this.mNext && !this.hasNext()) {
            throw new NoSuchElementException("No more nodes in the axis!");
        }
        if (this.mKey >= 0L) {
            if (!this.mRtx.hasNode(this.mKey)) throw new IllegalStateException("Failed to move to nodeKey: " + this.mKey);
            this.mRtx.moveTo(this.mKey);
        } else {
            this.mRtx.moveTo(this.mKey);
        }
        this.mNext = false;
        return this.mKey;
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset(@Nonnegative long pNodeKey) {
        this.mStartKey = pNodeKey;
        this.mKey = pNodeKey;
        this.mNext = false;
        this.mHasNext = true;
    }

    @Override
    public XmlNodeReadOnlyTrx asXdmNodeReadTrx() {
        if (this.mRtx instanceof NodeReadOnlyTrx) {
            return (XmlNodeReadOnlyTrx)this.mRtx;
        }
        throw new ClassCastException("Node cursor is no XDM node transaction.");
    }

    @Override
    public JsonNodeReadOnlyTrx asJsonNodeReadTrx() {
        throw new ClassCastException("Node cursor is no JSON node transaction.");
    }

    @Override
    public NodeReadOnlyTrx getTrx() {
        if (this.mRtx instanceof NodeReadOnlyTrx) {
            return (XmlNodeReadOnlyTrx)this.mRtx;
        }
        throw new IllegalStateException("Node cursor is no transaction cursor.");
    }

    @Override
    public PathSummaryReader asPathSummary() {
        if (this.mRtx instanceof PathSummaryReader) {
            return (PathSummaryReader)this.mRtx;
        }
        throw new ClassCastException("Node cursor is no path summary reader.");
    }

    @Override
    public NodeCursor getCursor() {
        return this.mRtx;
    }

    public boolean isHasNext() {
        return this.mHasNext;
    }

    protected final long resetToStartKey() {
        this.mRtx.moveTo(this.mStartKey);
        this.mNext = false;
        this.mHasNext = false;
        return this.mStartKey;
    }

    protected final long resetToLastKey() {
        this.mRtx.moveTo(this.mKey);
        this.mNext = true;
        return this.mKey;
    }

    @Override
    public final long getStartKey() {
        return this.mStartKey;
    }

    @Override
    public final IncludeSelf isSelfIncluded() {
        return this.mIncludeSelf;
    }

    public Long peek() {
        return null;
    }

    public final boolean isNext() {
        return this.mNext;
    }

    @Override
    public final void foreach(XmlNodeVisitor pVisitor) {
        Preconditions.checkNotNull((Object)pVisitor);
        while (this.hasNext()) {
            ((XmlNodeReadOnlyTrx)this.mRtx).acceptVisitor(pVisitor);
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final synchronized long nextNode() {
        NodeCursor nodeCursor = this.mRtx;
        synchronized (nodeCursor) {
            long retVal = Fixed.NULL_NODE_KEY.getStandardProperty();
            if (this.hasNext()) {
                retVal = this.next();
            }
            return retVal;
        }
    }
}

