/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.shredder;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import java.util.Queue;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public final class QueueEventReader
implements XMLEventReader {
    private final Queue<XMLEvent> mEvents;

    public QueueEventReader(Queue<XMLEvent> events) {
        this.mEvents = (Queue)Preconditions.checkNotNull(events);
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public String getElementText() throws XMLStreamException {
        StringBuffer buffer = new StringBuffer();
        if (this.mEvents.peek().getEventType() != 1) {
            throw new XMLStreamException("Current event is not a start tag!");
        }
        QName root = this.mEvents.poll().asStartElement().getName();
        int level = 0;
        while (!(level < 0 || this.mEvents.peek().isEndElement() && this.mEvents.peek().asEndElement().getName().equals(root))) {
            XMLEvent event = this.mEvents.poll();
            switch (event.getEventType()) {
                case 1: {
                    ++level;
                    break;
                }
                case 4: {
                    buffer.append(event.asCharacters().getData());
                    break;
                }
                case 2: {
                    --level;
                    break;
                }
            }
        }
        return buffer.toString();
    }

    @Override
    public Object getProperty(String paramName) throws IllegalArgumentException {
        return null;
    }

    @Override
    public boolean hasNext() {
        boolean retVal = true;
        if (this.mEvents.isEmpty()) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public XMLEvent nextEvent() throws XMLStreamException {
        XMLEvent retVal;
        try {
            retVal = this.mEvents.poll();
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
        return retVal;
    }

    @Override
    public XMLEvent nextTag() throws XMLStreamException {
        XMLEvent event = this.mEvents.poll();
        while (!event.isStartElement() || !event.isEndElement()) {
            if (event.isCharacters() && !event.asCharacters().isWhiteSpace()) {
                throw new XMLStreamException("Encountered anything different from a whitespace!");
            }
            event = this.mEvents.poll();
        }
        return this.mEvents.peek();
    }

    @Override
    public XMLEvent peek() throws XMLStreamException {
        XMLEvent retVal = null;
        try {
            retVal = this.mEvents.peek();
        }
        catch (IndexOutOfBoundsException e) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public Object next() {
        XMLEvent retVal = null;
        try {
            retVal = this.nextEvent();
        }
        catch (XMLStreamException e) {
            retVal = null;
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported!");
    }

    public XMLEventReader copy() {
        return new QueueEventReader(this.mEvents);
    }
}

