/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.serialize;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.Utils;
import org.sirix.api.Database;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.exception.SirixException;
import org.sirix.service.AbstractSerializer;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.XMLToken;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public final class SAXSerializer
extends AbstractSerializer<XmlNodeReadOnlyTrx, XmlNodeTrx>
implements XMLReader {
    private final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(SAXSerializer.class));
    private ContentHandler mContHandler;

    public SAXSerializer(XmlResourceManager resMgr, ContentHandler handler, @Nonnegative int revision, int ... revisions) {
        super(resMgr, revision, revisions);
        this.mContHandler = handler;
    }

    @Override
    protected void emitNode(XmlNodeReadOnlyTrx rtx) {
        switch (rtx.getKind()) {
            case XDM_DOCUMENT: {
                break;
            }
            case ELEMENT: {
                this.generateElement(rtx);
                break;
            }
            case TEXT: {
                this.generateText(rtx);
                break;
            }
            case COMMENT: {
                this.generateComment(rtx);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.generatePI(rtx);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Node kind not supported by sirix!");
            }
        }
    }

    @Override
    protected void emitEndNode(XmlNodeReadOnlyTrx rtx) {
        QNm qName = rtx.getName();
        String mURI = qName.getNamespaceURI();
        try {
            this.mContHandler.endPrefixMapping(qName.getPrefix());
            this.mContHandler.endElement(mURI, qName.getLocalName(), Utils.buildName(qName));
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@Nonnull XmlNodeReadOnlyTrx rtx) {
        int length;
        int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
        if (length > 1) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("sdb", "revision", "sdb:revision", "", Integer.toString(rtx.getRevisionNumber()));
            try {
                this.mContHandler.startElement("https://sirix.io", "sirix-item", "sdb:sirix-item", atts);
            }
            catch (SAXException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    @Override
    protected void emitRevisionEndNode(@Nonnull XmlNodeReadOnlyTrx rtx) {
        int length;
        int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
        if (length > 1) {
            try {
                this.mContHandler.endElement("https://sirix.io", "sirix-item", "sdb:sirix-item");
            }
            catch (SAXException e) {
                this.LOGGER.error(e.getMessage(), e);
            }
        }
    }

    private void generateComment(XmlNodeReadOnlyTrx rtx) {
        try {
            char[] content = rtx.getValue().toCharArray();
            this.mContHandler.characters(content, 0, content.length);
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generatePI(XmlNodeReadOnlyTrx rtx) {
        try {
            this.mContHandler.processingInstruction(rtx.getName().getLocalName(), rtx.getValue());
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generateElement(XmlNodeReadOnlyTrx rtx) {
        AttributesImpl atts = new AttributesImpl();
        long key = rtx.getNodeKey();
        try {
            String mURI;
            QNm qName;
            int i;
            int namesCount = rtx.getNamespaceCount();
            for (i = 0; i < namesCount; ++i) {
                rtx.moveToNamespace(i);
                qName = rtx.getName();
                this.mContHandler.startPrefixMapping(qName.getPrefix(), qName.getNamespaceURI());
                mURI = qName.getNamespaceURI();
                if (qName.getPrefix() == null || qName.getPrefix().length() == 0) {
                    atts.addAttribute(mURI, "xmlns", "xmlns", "CDATA", mURI);
                } else {
                    atts.addAttribute(mURI, "xmlns", "xmlns:" + rtx.getName().getPrefix(), "CDATA", mURI);
                }
                rtx.moveTo(key);
            }
            int attCount = rtx.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                rtx.moveToAttribute(i);
                qName = rtx.getName();
                mURI = qName.getNamespaceURI();
                atts.addAttribute(mURI, qName.getLocalName(), Utils.buildName(qName), rtx.getType(), rtx.getValue());
                rtx.moveTo(key);
            }
            QNm qName2 = rtx.getName();
            this.mContHandler.startElement(qName2.getNamespaceURI(), qName2.getLocalName(), Utils.buildName(qName2), atts);
            if (!rtx.hasFirstChild()) {
                this.mContHandler.endElement(qName2.getNamespaceURI(), qName2.getLocalName(), Utils.buildName(qName2));
            }
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    private void generateText(XmlNodeReadOnlyTrx rtx) {
        try {
            this.mContHandler.characters(XMLToken.escapeContent(rtx.getValue()).toCharArray(), 0, rtx.getValue().length());
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    public static void main(String ... args) {
        Path path = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(path);
        Databases.createXmlDatabase(config);
        Database<XmlResourceManager> database = Databases.openXmlDatabase(path);
        database.createResource(new ResourceConfiguration.Builder("shredded").build());
        try (XmlResourceManager resource = database.openResourceManager("shredded");){
            DefaultHandler defHandler = new DefaultHandler();
            SAXSerializer serializer = new SAXSerializer(resource, defHandler, resource.getMostRecentRevisionNumber(), new int[0]);
            serializer.call();
        }
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            this.mContHandler.startDocument();
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (length > 1) {
                String ns = "https://sirix.io";
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("https://sirix.io", "xmlns", "xmlns:sdb", "", "https://sirix.io");
                this.mContHandler.startElement("sdb", "sirix", "sdb:sirix", atts);
            }
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (length > 1) {
                this.mContHandler.endElement("sdb", "sirix", "sdb:sirix");
            }
            this.mContHandler.endDocument();
        }
        catch (SAXException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.mContHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void parse(String systemID) throws IOException, SAXException {
        this.emitStartDocument();
        try {
            super.call();
        }
        catch (SirixException e) {
            this.LOGGER.error(e.getMessage(), e);
        }
        this.emitEndDocument();
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.mContHandler = (ContentHandler)Preconditions.checkNotNull((Object)contentHandler);
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        throw new SAXNotSupportedException();
    }
}

