/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.json.shredder;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Callable;
import javax.xml.stream.XMLStreamException;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.access.trx.node.json.objectvalue.ArrayValue;
import org.sirix.access.trx.node.json.objectvalue.BooleanValue;
import org.sirix.access.trx.node.json.objectvalue.NullValue;
import org.sirix.access.trx.node.json.objectvalue.NumberValue;
import org.sirix.access.trx.node.json.objectvalue.ObjectRecordValue;
import org.sirix.access.trx.node.json.objectvalue.ObjectValue;
import org.sirix.access.trx.node.json.objectvalue.StringValue;
import org.sirix.api.Database;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.api.json.JsonResourceManager;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.node.Kind;
import org.sirix.service.ShredderCommit;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class JsonShredder
implements Callable<Long> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(JsonShredder.class));
    private final JsonNodeTrx mWtx;
    private final JsonReader mReader;
    private final ShredderCommit mCommit;
    private final Deque<Long> mParents;
    private InsertPosition mInsert;
    private int mLevel;
    private final boolean mSkipRootJson;

    private JsonShredder(Builder builder) {
        this.mWtx = builder.mWtx;
        this.mReader = builder.mReader;
        this.mInsert = builder.mInsert;
        this.mCommit = builder.mCommit;
        this.mSkipRootJson = builder.mSkipRootJsonToken;
        this.mParents = new ArrayDeque<Long>();
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
    }

    @Override
    public Long call() throws SirixException {
        long revision = this.mWtx.getRevisionNumber();
        this.insertNewContent();
        this.mCommit.commit(this.mWtx);
        return revision;
    }

    protected final void insertNewContent() {
        try {
            this.mLevel = 0;
            boolean endReached = false;
            long insertedRootNodeKey = -1L;
            block13: while (this.mReader.peek() != JsonToken.END_DOCUMENT && !endReached) {
                JsonToken nextToken = this.mReader.peek();
                switch (nextToken) {
                    case BEGIN_OBJECT: {
                        ++this.mLevel;
                        this.mReader.beginObject();
                        if (this.mLevel == 1 && this.mSkipRootJson) break;
                        long insertedObjectNodeKey = this.addObject();
                        if (insertedRootNodeKey != -1L) continue block13;
                        insertedRootNodeKey = insertedObjectNodeKey;
                        break;
                    }
                    case NAME: {
                        String name = this.mReader.nextName();
                        this.addObjectRecord(name);
                        break;
                    }
                    case END_OBJECT: {
                        --this.mLevel;
                        if (this.mLevel == 0) {
                            endReached = true;
                        }
                        this.mReader.endObject();
                        if (this.mLevel == 0 && this.mSkipRootJson) break;
                        this.mParents.pop();
                        this.mWtx.moveTo(this.mParents.peek());
                        if (this.mReader.peek() != JsonToken.NAME && this.mReader.peek() != JsonToken.END_OBJECT) break;
                        this.mParents.pop();
                        this.mWtx.moveTo(this.mParents.peek());
                        break;
                    }
                    case BEGIN_ARRAY: {
                        ++this.mLevel;
                        this.mReader.beginArray();
                        if (this.mLevel == 1 && this.mSkipRootJson) break;
                        long insertedArrayNodeKey = this.insertArray();
                        if (insertedRootNodeKey != -1L) continue block13;
                        insertedRootNodeKey = insertedArrayNodeKey;
                        break;
                    }
                    case END_ARRAY: {
                        --this.mLevel;
                        if (this.mLevel == 0) {
                            endReached = true;
                        }
                        this.mReader.endArray();
                        if (this.mLevel == 0 && this.mSkipRootJson) break;
                        this.mParents.pop();
                        this.mWtx.moveTo(this.mParents.peek());
                        if (this.mReader.peek() != JsonToken.NAME && this.mReader.peek() != JsonToken.END_OBJECT) break;
                        this.mParents.pop();
                        this.mWtx.moveTo(this.mParents.peek());
                        break;
                    }
                    case STRING: {
                        String string = this.mReader.nextString();
                        long insertedStringValueNodeKey = this.insertStringValue(string, this.mReader.peek() == JsonToken.NAME || this.mReader.peek() == JsonToken.END_OBJECT);
                        if (insertedRootNodeKey != -1L) break;
                        insertedRootNodeKey = insertedStringValueNodeKey;
                        break;
                    }
                    case BOOLEAN: {
                        boolean bool = this.mReader.nextBoolean();
                        long insertedBooleanValueNodeKey = this.insertBooleanValue(bool, this.mReader.peek() == JsonToken.NAME || this.mReader.peek() == JsonToken.END_OBJECT);
                        if (insertedRootNodeKey != -1L) break;
                        insertedRootNodeKey = insertedBooleanValueNodeKey;
                        break;
                    }
                    case NULL: {
                        this.mReader.nextNull();
                        long insertedNullValueNodeKey = this.insertNullValue(this.mReader.peek() == JsonToken.NAME || this.mReader.peek() == JsonToken.END_OBJECT);
                        if (insertedRootNodeKey != -1L) break;
                        insertedRootNodeKey = insertedNullValueNodeKey;
                        break;
                    }
                    case NUMBER: {
                        Number number = this.readNumber();
                        long insertedNumberValueNodeKey = this.insertNumberValue(number, this.mReader.peek() == JsonToken.NAME || this.mReader.peek() == JsonToken.END_OBJECT);
                        if (insertedRootNodeKey != -1L) break;
                        insertedRootNodeKey = insertedNumberValueNodeKey;
                        break;
                    }
                }
            }
            this.mWtx.moveTo(insertedRootNodeKey);
        }
        catch (IOException e) {
            throw new SirixIOException(e);
        }
    }

    private Number readNumber() throws IOException {
        Number number;
        String stringVal = this.mReader.nextString();
        if (stringVal.contains(".")) {
            if (stringVal.contains("E") || stringVal.contains("e")) {
                try {
                    number = Float.valueOf(stringVal);
                }
                catch (NumberFormatException eeee) {
                    try {
                        number = Double.valueOf(stringVal);
                    }
                    catch (NumberFormatException eeeee) {
                        throw new IllegalStateException(eeeee);
                    }
                }
            } else {
                try {
                    number = new BigDecimal(stringVal);
                }
                catch (NumberFormatException eeeeee) {
                    throw new IllegalStateException(eeeeee);
                }
            }
        } else {
            try {
                number = Integer.valueOf(stringVal);
            }
            catch (NumberFormatException e) {
                try {
                    number = Long.valueOf(stringVal);
                }
                catch (NumberFormatException ee) {
                    try {
                        number = new BigInteger(stringVal);
                    }
                    catch (NumberFormatException eee) {
                        throw new IllegalStateException(eee);
                    }
                }
            }
        }
        return number;
    }

    private long insertStringValue(String stringValue, boolean nextTokenIsParent) {
        String value = (String)Preconditions.checkNotNull((Object)stringValue);
        long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertStringValueAsFirstChild(value).getNodeKey() : this.mWtx.insertStringValueAsRightSibling(value).getNodeKey();
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertBooleanValue(boolean boolValue, boolean nextTokenIsParent) {
        boolean value = (Boolean)Preconditions.checkNotNull((Object)boolValue);
        long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertBooleanValueAsFirstChild(value).getNodeKey() : this.mWtx.insertBooleanValueAsRightSibling(value).getNodeKey();
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertNumberValue(Number numberValue, boolean nextTokenIsParent) {
        Number value = (Number)Preconditions.checkNotNull((Object)numberValue);
        if (value != null) {
            long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertNumberValueAsFirstChild(value).getNodeKey() : this.mWtx.insertNumberValueAsRightSibling(value).getNodeKey();
            this.adaptTrxPosAndStack(nextTokenIsParent, key);
            return key;
        }
        return -1L;
    }

    private void adaptTrxPosAndStack(boolean nextTokenIsParent, long key) {
        this.mParents.pop();
        if (nextTokenIsParent) {
            this.mWtx.moveTo(this.mParents.peek());
        } else {
            this.mParents.push(key);
        }
    }

    private long insertNullValue(boolean nextTokenIsParent) {
        long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertNullValueAsFirstChild().getNodeKey() : this.mWtx.insertNullValueAsRightSibling().getNodeKey();
        this.adaptTrxPosAndStack(nextTokenIsParent, key);
        return key;
    }

    private long insertArray() {
        long key = -1L;
        switch (this.mInsert) {
            case AS_FIRST_CHILD: {
                if (this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.mWtx.insertArrayAsFirstChild().getNodeKey();
                    break;
                }
                key = this.mWtx.insertArrayAsRightSibling().getNodeKey();
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.mWtx.getKind() == Kind.JSON_DOCUMENT || this.mWtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.mWtx.insertArrayAsRightSibling().getNodeKey();
                this.mInsert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mParents.pop();
        this.mParents.push(key);
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private long addObject() {
        long key = -1L;
        switch (this.mInsert) {
            case AS_FIRST_CHILD: {
                if (this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
                    key = this.mWtx.insertObjectAsFirstChild().getNodeKey();
                    break;
                }
                key = this.mWtx.insertObjectAsRightSibling().getNodeKey();
                break;
            }
            case AS_RIGHT_SIBLING: {
                if (this.mWtx.getKind() == Kind.JSON_DOCUMENT || this.mWtx.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
                    throw new IllegalStateException("Subtree can not be inserted as sibling of document root or the root-object/array/whatever!");
                }
                key = this.mWtx.insertObjectAsRightSibling().getNodeKey();
                this.mInsert = InsertPosition.AS_FIRST_CHILD;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.mParents.pop();
        this.mParents.push(key);
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        return key;
    }

    private void addObjectRecord(String name) throws IOException {
        ObjectRecordValue<Void> value;
        assert (name != null);
        JsonToken nextToken = this.mReader.peek();
        switch (nextToken) {
            case BEGIN_OBJECT: {
                ++this.mLevel;
                this.mReader.beginObject();
                value = new ObjectValue();
                break;
            }
            case BEGIN_ARRAY: {
                ++this.mLevel;
                this.mReader.beginArray();
                value = new ArrayValue();
                break;
            }
            case BOOLEAN: {
                boolean booleanVal = this.mReader.nextBoolean();
                value = new BooleanValue(booleanVal);
                break;
            }
            case STRING: {
                String stringVal = this.mReader.nextString();
                value = new StringValue(stringVal);
                break;
            }
            case NULL: {
                this.mReader.nextNull();
                value = new NullValue();
                break;
            }
            case NUMBER: {
                Number numberVal = this.readNumber();
                value = new NumberValue(numberVal);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        long key = this.mParents.peek().longValue() == Fixed.NULL_NODE_KEY.getStandardProperty() ? this.mWtx.insertObjectRecordAsFirstChild(name, value).getNodeKey() : this.mWtx.insertObjectRecordAsRightSibling(name, value).getNodeKey();
        this.mParents.pop();
        this.mParents.push(this.mWtx.getParentKey());
        this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        if (this.mWtx.getKind() == Kind.OBJECT || this.mWtx.getKind() == Kind.ARRAY) {
            this.mParents.pop();
            this.mParents.push(key);
            this.mParents.push(Fixed.NULL_NODE_KEY.getStandardProperty());
        } else {
            boolean isNextTokenParentToken = this.mReader.peek() == JsonToken.NAME || this.mReader.peek() == JsonToken.END_OBJECT;
            this.adaptTrxPosAndStack(isNextTokenParentToken, key);
        }
    }

    public static void main(String ... args) throws SirixException, IOException, XMLStreamException {
        if (args.length != 2 && args.length != 3) {
            throw new IllegalArgumentException("Usage: XMLShredder XMLFile Database [true/false] (shredder comment|PI)");
        }
        LOGWRAPPER.info("Shredding '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path targetDatabasePath = Paths.get(args[1], new String[0]);
        DatabaseConfiguration databaseConfig = new DatabaseConfiguration(targetDatabasePath);
        Databases.removeDatabase(targetDatabasePath);
        Databases.createJsonDatabase(databaseConfig);
        try (Database<JsonResourceManager> db = Databases.openJsonDatabase(targetDatabasePath);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (JsonResourceManager resMgr = db.openResourceManager("shredded");
                 JsonNodeTrx wtx = (JsonNodeTrx)resMgr.beginNodeTrx();){
                Path path = Paths.get(args[0], new String[0]);
                JsonReader jsonReader = JsonShredder.createFileReader(path);
                JsonShredder shredder = new Builder(wtx, jsonReader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().build();
                shredder.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + " ms].", new Object[0]);
    }

    public static JsonReader createFileReader(Path path) {
        Preconditions.checkNotNull((Object)path);
        try {
            FileReader fileReader = new FileReader(path.toFile());
            return new JsonReader((Reader)fileReader);
        }
        catch (FileNotFoundException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static JsonReader createStringReader(String json) {
        Preconditions.checkNotNull((Object)json);
        StringReader stringReader = new StringReader(json);
        return new JsonReader((Reader)stringReader);
    }

    public static class Builder {
        private final JsonNodeTrx mWtx;
        private final JsonReader mReader;
        private final InsertPosition mInsert;
        private ShredderCommit mCommit = ShredderCommit.NOCOMMIT;
        private boolean mSkipRootJsonToken;

        public Builder(JsonNodeTrx wtx, JsonReader reader, InsertPosition insert) {
            this.mWtx = (JsonNodeTrx)Preconditions.checkNotNull((Object)wtx);
            this.mReader = (JsonReader)Preconditions.checkNotNull((Object)reader);
            this.mInsert = (InsertPosition)((Object)Preconditions.checkNotNull((Object)((Object)insert)));
        }

        public Builder commitAfterwards() {
            this.mCommit = ShredderCommit.COMMIT;
            return this;
        }

        public Builder skipRootJsonToken() {
            this.mSkipRootJsonToken = true;
            return this;
        }

        public JsonShredder build() {
            return new JsonShredder(this);
        }
    }
}

