/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.exception.SirixIOException;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.Utils;
import org.sirix.node.interfaces.NodePersistenter;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.RecordPersister;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.page.OverflowPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.SerializationType;
import org.sirix.page.interfaces.KeyValuePage;

public final class UnorderedKeyValuePage
implements KeyValuePage<Long, Record> {
    private boolean mAddedReferences;
    private final Map<Long, PageReference> mReferences;
    private final long mRecordPageKey;
    private final LinkedHashMap<Long, Record> mRecords;
    private final Map<Long, byte[]> mSlots;
    private final Map<SirixDeweyID, Long> mDeweyIDs;
    private final PageReadOnlyTrx mPageReadTrx;
    private final PageKind mPageKind;
    private final RecordPersister mRecordPersister;
    private long mPreviousPageRefKey;
    private final ResourceConfiguration mResourceConfig;

    public UnorderedKeyValuePage(@Nonnegative long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        assert (recordPageKey >= 0L) : "recordPageKey must not be negative!";
        assert (pageReadTrx != null) : "The page reading trx must not be null!";
        this.mReferences = new LinkedHashMap<Long, PageReference>();
        this.mRecordPageKey = recordPageKey;
        this.mRecords = new LinkedHashMap();
        this.mSlots = new LinkedHashMap<Long, byte[]>();
        this.mPageReadTrx = pageReadTrx;
        this.mPageKind = pageKind;
        this.mResourceConfig = pageReadTrx.getResourceManager().getResourceConfig();
        this.mRecordPersister = this.mResourceConfig.recordPersister;
        this.mPreviousPageRefKey = previousPageRefKey;
        this.mDeweyIDs = this.mPageReadTrx.getResourceManager().getResourceConfig().areDeweyIDsStored && this.mRecordPersister instanceof NodePersistenter ? new LinkedHashMap<SirixDeweyID, Long>() : Collections.emptyMap();
    }

    protected UnorderedKeyValuePage(DataInput in, PageReadOnlyTrx pageReadTrx) throws IOException {
        this.mRecordPageKey = Utils.getVarLong(in);
        this.mResourceConfig = pageReadTrx.getResourceManager().getResourceConfig();
        this.mRecordPersister = this.mResourceConfig.recordPersister;
        this.mPageReadTrx = pageReadTrx;
        this.mSlots = new LinkedHashMap<Long, byte[]>();
        if (this.mResourceConfig.areDeweyIDsStored && this.mRecordPersister instanceof NodePersistenter) {
            this.mDeweyIDs = new LinkedHashMap<SirixDeweyID, Long>();
            NodePersistenter persistenter = (NodePersistenter)this.mRecordPersister;
            int deweyIDSize = in.readInt();
            this.mRecords = new LinkedHashMap(deweyIDSize);
            Optional<Object> id = Optional.empty();
            for (int index = 0; index < deweyIDSize; ++index) {
                id = persistenter.deserializeDeweyID(in, id.orElse(null), this.mResourceConfig);
                id.ifPresent(deweyId -> {
                    try {
                        long key = Utils.getVarLong(in);
                        int dataSize = in.readInt();
                        byte[] data = new byte[dataSize];
                        in.readFully(data);
                        Record record = this.mRecordPersister.deserialize(new DataInputStream(new ByteArrayInputStream(data)), key, (SirixDeweyID)deweyId, this.mPageReadTrx);
                        this.mRecords.put(key, record);
                    }
                    catch (IOException e) {
                        throw new SirixIOException(e);
                    }
                });
            }
        } else {
            this.mDeweyIDs = Collections.emptyMap();
            this.mRecords = new LinkedHashMap();
        }
        int normalEntrySize = in.readInt();
        for (int index = 0; index < normalEntrySize; ++index) {
            long key = Utils.getVarLong(in);
            int dataSize = in.readInt();
            byte[] data = new byte[dataSize];
            in.readFully(data);
            Record record = this.mRecordPersister.deserialize(new DataInputStream(new ByteArrayInputStream(data)), key, null, this.mPageReadTrx);
            this.mRecords.put(key, record);
        }
        int overlongEntrySize = in.readInt();
        this.mReferences = new LinkedHashMap<Long, PageReference>(overlongEntrySize);
        for (int index = 0; index < overlongEntrySize; ++index) {
            long key = in.readLong();
            PageReference reference = new PageReference();
            reference.setKey(in.readLong());
            this.mReferences.put(key, reference);
        }
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        boolean hasPreviousReference = in.readBoolean();
        this.mPreviousPageRefKey = hasPreviousReference ? in.readLong() : -15L;
        this.mPageKind = PageKind.getKind(in.readByte());
    }

    @Override
    public long getPageKey() {
        return this.mRecordPageKey;
    }

    @Override
    public Record getValue(Long key) {
        assert (key != null) : "key must not be null!";
        Record record = this.mRecords.get(key);
        if (record == null) {
            byte[] data = null;
            try {
                PageReference reference = this.mReferences.get(key);
                if (reference == null || reference.getKey() == -15L) {
                    return null;
                }
                data = ((OverflowPage)this.mPageReadTrx.getReader().read(reference, this.mPageReadTrx)).getData();
            }
            catch (SirixIOException e) {
                return null;
            }
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            try {
                record = this.mRecordPersister.deserialize(new DataInputStream(in), key, null, null);
            }
            catch (IOException e) {
                return null;
            }
            this.mRecords.put(key, record);
        }
        return record;
    }

    @Override
    public void setEntry(Long key, Record value) {
        assert (value != null) : "record must not be null!";
        this.mAddedReferences = false;
        this.mRecords.put(key, value);
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        if (!this.mAddedReferences) {
            this.addReferences();
        }
        Utils.putVarLong(out, this.mRecordPageKey);
        if (this.mResourceConfig.areDeweyIDsStored && this.mRecordPersister instanceof NodePersistenter) {
            Iterator<Map.Entry<Long, PageReference>> persistenter = (NodePersistenter)this.mRecordPersister;
            out.writeInt(this.mDeweyIDs.size());
            ArrayList<SirixDeweyID> arrayList = new ArrayList<SirixDeweyID>(this.mDeweyIDs.keySet());
            arrayList.sort((first, second) -> Integer.valueOf(first.toBytes().length).compareTo(second.toBytes().length));
            PeekingIterator iter = Iterators.peekingIterator(arrayList.iterator());
            SirixDeweyID id = null;
            if (iter.hasNext()) {
                id = (SirixDeweyID)iter.next();
                persistenter.serializeDeweyID(out, Kind.ELEMENT, id, null, this.mResourceConfig);
                this.serializeDeweyRecord(id, out);
            }
            while (iter.hasNext()) {
                SirixDeweyID nextDeweyID = (SirixDeweyID)iter.next();
                persistenter.serializeDeweyID(out, Kind.ELEMENT, id, nextDeweyID, this.mResourceConfig);
                this.serializeDeweyRecord(nextDeweyID, out);
                id = nextDeweyID;
            }
        }
        out.writeInt(this.mSlots.size());
        for (Map.Entry entry : this.mSlots.entrySet()) {
            Utils.putVarLong(out, (Long)entry.getKey());
            byte[] data = (byte[])entry.getValue();
            int length = data.length;
            out.writeInt(length);
            out.write(data);
        }
        out.writeInt(this.mReferences.size());
        for (Map.Entry<Long, PageReference> entry : this.mReferences.entrySet()) {
            out.writeLong(entry.getKey());
            out.writeLong(entry.getValue().getKey());
        }
        boolean hasPreviousReference = this.mPreviousPageRefKey != -15L;
        out.writeBoolean(hasPreviousReference);
        if (hasPreviousReference) {
            out.writeLong(this.mPreviousPageRefKey);
        }
        out.writeByte(this.mPageKind.getID());
    }

    private void serializeDeweyRecord(SirixDeweyID id, DataOutput out) throws IOException {
        long recordKey = this.mDeweyIDs.get(id);
        Utils.putVarLong(out, recordKey);
        byte[] data = this.mSlots.get(recordKey);
        int length = data.length;
        out.writeInt(length);
        out.write(data);
        this.mSlots.remove(recordKey);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this).add("pagekey", this.mRecordPageKey);
        for (Record record : this.mRecords.values()) {
            helper.add("record", (Object)record);
        }
        for (PageReference reference : this.mReferences.values()) {
            helper.add("reference", (Object)reference);
        }
        return helper.toString();
    }

    @Override
    public Set<Map.Entry<Long, Record>> entrySet() {
        return this.mRecords.entrySet();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mRecordPageKey, this.mRecords, this.mReferences});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnorderedKeyValuePage) {
            UnorderedKeyValuePage other = (UnorderedKeyValuePage)obj;
            return this.mRecordPageKey == other.mRecordPageKey && Objects.equal(this.mRecords, other.mRecords) && Objects.equal(this.mReferences, other.mReferences);
        }
        return false;
    }

    @Override
    public List<PageReference> getReferences() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <K extends Comparable<? super K>, V extends Record, S extends KeyValuePage<K, V>> void commit(PageTrx<K, V, S> pageWriteTrx) {
        if (!this.mAddedReferences) {
            try {
                this.addReferences();
            }
            catch (IOException e) {
                throw new SirixIOException(e);
            }
        }
        for (PageReference reference : this.mReferences.values()) {
            if (reference.getPage() == null && reference.getKey() == -15L && (long)reference.getLogKey() == -15L) continue;
            pageWriteTrx.commit(reference);
        }
    }

    private void addReferences() throws IOException {
        boolean storeDeweyIDs = this.mPageReadTrx.getResourceManager().getResourceConfig().areDeweyIDsStored;
        List<Map.Entry<Long, Record>> entries = this.sort();
        for (Map.Entry<Long, Record> entry : entries) {
            Record record = entry.getValue();
            long recordID = record.getNodeKey();
            if (this.mSlots.get(recordID) != null) continue;
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            this.mRecordPersister.serialize(out, record, this.mPageReadTrx);
            byte[] data = output.toByteArray();
            if (data.length > 150000) {
                PageReference reference = new PageReference();
                reference.setPage(new OverflowPage(data));
                this.mReferences.put(recordID, reference);
                continue;
            }
            if (storeDeweyIDs && this.mRecordPersister instanceof NodePersistenter && record instanceof ImmutableXmlNode && ((ImmutableXmlNode)record).getDeweyID().isPresent() && record.getNodeKey() != 0L) {
                this.mDeweyIDs.put(((ImmutableXmlNode)record).getDeweyID().get(), record.getNodeKey());
            }
            this.mSlots.put(recordID, data);
        }
        this.mAddedReferences = true;
    }

    private List<Map.Entry<Long, Record>> sort() {
        ArrayList<Map.Entry<Long, Record>> entries = new ArrayList<Map.Entry<Long, Record>>(this.mRecords.entrySet());
        boolean storeDeweyIDs = this.mPageReadTrx.getResourceManager().getResourceConfig().areDeweyIDsStored;
        if (storeDeweyIDs && this.mRecordPersister instanceof NodePersistenter) {
            entries.sort((a, b) -> {
                if (a.getValue() instanceof ImmutableXmlNode && b.getValue() instanceof ImmutableXmlNode) {
                    Optional<SirixDeweyID> first = ((ImmutableXmlNode)a.getValue()).getDeweyID();
                    Optional<SirixDeweyID> second = ((ImmutableXmlNode)b.getValue()).getDeweyID();
                    if (!first.isPresent() && second.isPresent()) {
                        return 1;
                    }
                    if (!second.isPresent() && first.isPresent()) {
                        return -1;
                    }
                    if (!first.isPresent() && !second.isPresent()) {
                        return 0;
                    }
                    return first.get().compareTo(second.get());
                }
                return -1;
            });
        }
        return entries;
    }

    @Override
    public Collection<Record> values() {
        return this.mRecords.values();
    }

    @Override
    public PageReference getReference(int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReference(int offset, PageReference pageReference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PageReadOnlyTrx getPageReadTrx() {
        return this.mPageReadTrx;
    }

    @Override
    public <C extends KeyValuePage<Long, Record>> C newInstance(long recordPageKey, PageKind pageKind, long previousPageRefKey, PageReadOnlyTrx pageReadTrx) {
        return (C)new UnorderedKeyValuePage(recordPageKey, pageKind, previousPageRefKey, pageReadTrx);
    }

    @Override
    public PageKind getPageKind() {
        return this.mPageKind;
    }

    @Override
    public int size() {
        return this.mRecords.size() + this.mReferences.size();
    }

    @Override
    public void setPageReference(Long key, PageReference reference) {
        assert (key != null);
        this.mReferences.put(key, reference);
    }

    @Override
    public Set<Map.Entry<Long, PageReference>> referenceEntrySet() {
        return this.mReferences.entrySet();
    }

    @Override
    public PageReference getPageReference(Long key) {
        assert (key != null);
        return this.mReferences.get(key);
    }

    @Override
    public long getPreviousReferenceKey() {
        return this.mPreviousPageRefKey;
    }
}

