/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.sirix.api.PageTrx;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.node.interfaces.Record;
import org.sirix.page.AbstractForwardingPage;
import org.sirix.page.IndirectPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.RevisionRootPage;
import org.sirix.page.SerializationType;
import org.sirix.page.delegates.PageDelegate;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;
import org.sirix.settings.Constants;

public final class UberPage
extends AbstractForwardingPage {
    private static final int INDIRECT_REFERENCE_OFFSET = 0;
    private final int mRevisionCount;
    private boolean mIsBootstrap;
    private final PageDelegate mDelegate;
    private RevisionRootPage mRootPage;
    private final int mRevision;
    private long mPreviousUberPageKey;
    private int mCurrentMaxLevelOfIndirectPages;

    public UberPage() {
        this.mDelegate = new PageDelegate(1);
        this.mRevision = 0;
        this.mRevisionCount = 1;
        this.mIsBootstrap = true;
        this.mPreviousUberPageKey = -1L;
        this.mRootPage = null;
        this.mCurrentMaxLevelOfIndirectPages = 1;
    }

    protected UberPage(DataInput in, SerializationType type) throws IOException {
        this.mDelegate = new PageDelegate(1, in, type);
        this.mRevisionCount = in.readInt();
        if (in.readBoolean()) {
            this.mPreviousUberPageKey = in.readLong();
        }
        this.mRevision = this.mRevisionCount == 0 ? 0 : this.mRevisionCount - 1;
        this.mIsBootstrap = false;
        this.mRootPage = null;
        this.mCurrentMaxLevelOfIndirectPages = in.readByte() & 0xFF;
    }

    public UberPage(UberPage committedUberPage, long previousUberPageKey) {
        this.mDelegate = new PageDelegate((Page)Preconditions.checkNotNull((Object)committedUberPage), committedUberPage.mDelegate.getBitmap());
        this.mPreviousUberPageKey = previousUberPageKey;
        if (committedUberPage.isBootstrap()) {
            this.mRevision = committedUberPage.mRevision;
            this.mRevisionCount = committedUberPage.mRevisionCount;
            this.mIsBootstrap = committedUberPage.mIsBootstrap;
            this.mRootPage = committedUberPage.mRootPage;
        } else {
            this.mRevision = committedUberPage.mRevision + 1;
            this.mRevisionCount = committedUberPage.mRevisionCount + 1;
            this.mIsBootstrap = false;
            this.mRootPage = null;
        }
        this.mCurrentMaxLevelOfIndirectPages = committedUberPage.mCurrentMaxLevelOfIndirectPages;
    }

    public long getPreviousUberPageKey() {
        return this.mPreviousUberPageKey;
    }

    public PageReference getIndirectPageReference() {
        return this.getReference(0);
    }

    public int getRevisionCount() {
        return this.mRevisionCount;
    }

    public int getRevisionNumber() {
        return this.mRevisionCount - 1;
    }

    public boolean isBootstrap() {
        return this.mIsBootstrap;
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        this.mDelegate.serialize((DataOutput)Preconditions.checkNotNull((Object)out), (SerializationType)((Object)Preconditions.checkNotNull((Object)((Object)type))));
        out.writeInt(this.mRevisionCount);
        out.writeBoolean(!this.mIsBootstrap);
        if (!this.mIsBootstrap) {
            out.writeLong(this.mPreviousUberPageKey);
        }
        out.writeByte(this.mCurrentMaxLevelOfIndirectPages);
        this.mIsBootstrap = false;
    }

    public int getCurrentMaxLevelOfIndirectPages() {
        return this.mCurrentMaxLevelOfIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages() {
        return ++this.mCurrentMaxLevelOfIndirectPages;
    }

    @Override
    public void setReference(int offset, PageReference pageReference) {
        this.delegate().setReference(0, pageReference);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("forwarding page", (Object)super.toString()).add("revisionCount", this.mRevisionCount).add("indirectPage", (Object)this.getReference(0)).add("isBootstrap", this.mIsBootstrap).toString();
    }

    @Override
    protected Page delegate() {
        return this.mDelegate;
    }

    public void createRevisionTree(TransactionIntentLog log) {
        IndirectPage page = null;
        PageReference reference = this.getIndirectPageReference();
        page = new IndirectPage();
        log.put(reference, PageContainer.getInstance(page, page));
        reference = page.getReference(0);
        this.mRootPage = new RevisionRootPage();
        Page namePage = this.mRootPage.getNamePageReference().getPage();
        log.put(this.mRootPage.getNamePageReference(), PageContainer.getInstance(namePage, namePage));
        Page casPage = this.mRootPage.getCASPageReference().getPage();
        log.put(this.mRootPage.getCASPageReference(), PageContainer.getInstance(casPage, casPage));
        Page pathPage = this.mRootPage.getPathPageReference().getPage();
        log.put(this.mRootPage.getPathPageReference(), PageContainer.getInstance(pathPage, pathPage));
        Page pathSummaryPage = this.mRootPage.getPathSummaryPageReference().getPage();
        log.put(this.mRootPage.getPathSummaryPageReference(), PageContainer.getInstance(pathSummaryPage, pathSummaryPage));
        log.put(reference, PageContainer.getInstance(this.mRootPage, this.mRootPage));
    }

    public int[] getPageCountExp(PageKind pageKind) {
        int[] inpLevelPageCountExp = new int[]{};
        switch (pageKind) {
            case PATHSUMMARYPAGE: {
                inpLevelPageCountExp = Constants.PATHINP_LEVEL_PAGE_COUNT_EXPONENT;
                break;
            }
            case PATHPAGE: 
            case CASPAGE: 
            case NAMEPAGE: 
            case RECORDPAGE: {
                inpLevelPageCountExp = Constants.INP_LEVEL_PAGE_COUNT_EXPONENT;
                break;
            }
            case UBERPAGE: {
                inpLevelPageCountExp = Constants.UBPINP_LEVEL_PAGE_COUNT_EXPONENT;
                break;
            }
            default: {
                throw new IllegalStateException("page kind not known!");
            }
        }
        return inpLevelPageCountExp;
    }

    public int getPageReferenceCount(PageKind pageKind) {
        int referenceCount;
        switch (pageKind) {
            case PATHSUMMARYPAGE: {
                referenceCount = 512;
                break;
            }
            case PATHPAGE: 
            case CASPAGE: 
            case NAMEPAGE: 
            case RECORDPAGE: {
                referenceCount = 512;
                break;
            }
            case UBERPAGE: {
                referenceCount = 512;
                break;
            }
            default: {
                throw new IllegalStateException("page kind not known!");
            }
        }
        return referenceCount;
    }

    public int getPageReferenceCountExp(PageKind pageKind) {
        int referenceCount;
        switch (pageKind) {
            case PATHSUMMARYPAGE: {
                referenceCount = 9;
                break;
            }
            case PATHPAGE: 
            case CASPAGE: 
            case NAMEPAGE: 
            case RECORDPAGE: {
                referenceCount = 9;
                break;
            }
            case UBERPAGE: {
                referenceCount = 9;
                break;
            }
            default: {
                throw new IllegalStateException("page kind not known!");
            }
        }
        return referenceCount;
    }

    public int getRevision() {
        return this.mRevision;
    }

    @Override
    public <K extends Comparable<? super K>, V extends Record, S extends KeyValuePage<K, V>> void commit(PageTrx<K, V, S> pageWriteTrx) {
        this.mDelegate.commit(pageWriteTrx);
    }

    public <K extends Comparable<? super K>, V extends Record, S extends KeyValuePage<K, V>> void commit(String commitMessage, PageTrx<K, V, S> pageWriteTrx) {
        pageWriteTrx.getActualRevisionRootPage().setCommitMessage(commitMessage);
        this.mDelegate.commit(pageWriteTrx);
    }
}

