/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sirix.page.interfaces.Page;

public final class PageReference {
    private Page mPage;
    private long mKey = -15L;
    private int mLogKey = -15;
    private long mPersistentLogKey = -15L;
    private int mLength;
    private byte[] mHashInBytes;

    public PageReference() {
    }

    public PageReference(PageReference reference) {
        this.mLogKey = reference.mLogKey;
        this.mPage = reference.mPage;
        this.mKey = reference.mKey;
        this.mPersistentLogKey = reference.mPersistentLogKey;
        this.mLength = reference.mLength;
    }

    public void setPage(@Nullable Page page) {
        this.mPage = page;
    }

    public Page getPage() {
        return this.mPage;
    }

    public PageReference setLength(int length) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0, (Object)"Length must be > 0.");
        this.mLength = length;
        return this;
    }

    public int getLength() {
        return this.mLength;
    }

    public long getKey() {
        return this.mKey;
    }

    public PageReference setKey(long key) {
        this.mKey = key;
        return this;
    }

    public int getLogKey() {
        return this.mLogKey;
    }

    public PageReference setLogKey(int key) {
        this.mLogKey = key;
        return this;
    }

    public long getPersistentLogKey() {
        return this.mPersistentLogKey;
    }

    public PageReference setPersistentLogKey(long key) {
        this.mPersistentLogKey = key;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logKey", this.mLogKey).add("persistentLogKey", this.mPersistentLogKey).add("key", this.mKey).add("page", (Object)this.mPage).toString();
    }

    public int hashCode() {
        return Objects.hash(this.mLogKey, this.mKey, this.mPersistentLogKey);
    }

    public boolean equals(@Nullable Object other) {
        if (other instanceof PageReference) {
            PageReference otherPageRef = (PageReference)other;
            return otherPageRef.mLogKey == this.mLogKey && otherPageRef.mKey == this.mKey && otherPageRef.mPersistentLogKey == this.mPersistentLogKey;
        }
        return false;
    }

    public void setHash(byte[] hashInBytes) {
        this.mHashInBytes = hashInBytes;
    }

    public byte[] getHash() {
        return this.mHashInBytes;
    }
}

