/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.immutable.xdm.ImmutableDocumentNode;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;

public final class XdmDocumentRootNode
extends AbstractStructForwardingNode
implements StructNode,
ImmutableXmlNode {
    private final NodeDelegate mNodeDel;
    private final StructNodeDelegate mStructNodeDel;

    public XdmDocumentRootNode(@Nonnull NodeDelegate nodeDel, @Nonnull StructNodeDelegate structDel) {
        this.mNodeDel = (NodeDelegate)Preconditions.checkNotNull((Object)nodeDel);
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structDel);
    }

    @Override
    public Kind getKind() {
        return Kind.XDM_DOCUMENT;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableDocumentNode.of(this));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof XdmDocumentRootNode) {
            XdmDocumentRootNode other = (XdmDocumentRootNode)obj;
            return Objects.equal((Object)this.mNodeDel, (Object)other.mNodeDel);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mNodeDel;
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mNodeDel.getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mNodeDel.getTypeKey();
    }
}

