/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.brackit.xquery.atomic.QNm;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.immutable.xdm.ImmutablePI;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;
import org.sirix.settings.Constants;

public final class PINode
extends AbstractStructForwardingNode
implements ValueNode,
NameNode,
ImmutableXmlNode {
    private final NameNodeDelegate mNameDel;
    private final ValNodeDelegate mValDel;
    private final StructNodeDelegate mStructNodeDel;
    private final PageReadOnlyTrx mPageReadTrx;

    public PINode(StructNodeDelegate structDel, NameNodeDelegate nameDel, ValNodeDelegate valDel, PageReadOnlyTrx pageReadTrx) {
        assert (structDel != null) : "structDel must not be null!";
        this.mStructNodeDel = structDel;
        assert (nameDel != null) : "nameDel must not be null!";
        this.mNameDel = nameDel;
        assert (valDel != null) : "valDel must not be null!";
        this.mValDel = valDel;
        assert (pageReadTrx != null) : "pageReadTrx must not be null!";
        this.mPageReadTrx = pageReadTrx;
    }

    @Override
    public Kind getKind() {
        return Kind.PROCESSING_INSTRUCTION;
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutablePI.of(this));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("structDel", (Object)this.mStructNodeDel).add("nameDel", (Object)this.mNameDel).add("valDel", (Object)this.mValDel).toString();
    }

    @Override
    public int getPrefixKey() {
        return this.mNameDel.getPrefixKey();
    }

    @Override
    public int getLocalNameKey() {
        return this.mNameDel.getLocalNameKey();
    }

    @Override
    public int getURIKey() {
        return this.mNameDel.getURIKey();
    }

    @Override
    public void setPrefixKey(int prefixKey) {
        this.mNameDel.setPrefixKey(prefixKey);
    }

    @Override
    public void setLocalNameKey(int localNameKey) {
        this.mNameDel.setLocalNameKey(localNameKey);
    }

    @Override
    public void setURIKey(int uriKey) {
        this.mNameDel.setURIKey(uriKey);
    }

    @Override
    public byte[] getRawValue() {
        return this.mValDel.getRawValue();
    }

    @Override
    public void setValue(byte[] value) {
        this.mValDel.setValue(value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNameDel, this.mValDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof PINode) {
            PINode other = (PINode)obj;
            return Objects.equal((Object)this.mNameDel, (Object)other.mNameDel) && Objects.equal((Object)this.mValDel, (Object)other.mValDel);
        }
        return false;
    }

    @Override
    public void setPathNodeKey(@Nonnegative long pathNodeKey) {
        this.mNameDel.setPathNodeKey(pathNodeKey);
    }

    @Override
    public long getPathNodeKey() {
        return this.mNameDel.getPathNodeKey();
    }

    public NameNodeDelegate getNameNodeDelegate() {
        return this.mNameDel;
    }

    public ValNodeDelegate getValNodeDelegate() {
        return this.mValDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    public QNm getName() {
        String uri = this.mPageReadTrx.getName(this.mNameDel.getURIKey(), Kind.NAMESPACE);
        int prefixKey = this.mNameDel.getPrefixKey();
        String prefix = prefixKey == -1 ? "" : this.mPageReadTrx.getName(prefixKey, Kind.PROCESSING_INSTRUCTION);
        int localNameKey = this.mNameDel.getLocalNameKey();
        String localName = localNameKey == -1 ? "" : this.mPageReadTrx.getName(localNameKey, Kind.PROCESSING_INSTRUCTION);
        return new QNm(uri, prefix, localName);
    }

    @Override
    public String getValue() {
        return new String(this.mValDel.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mStructNodeDel.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mStructNodeDel.getNodeDelegate().getTypeKey();
    }
}

