/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.node.AbstractForwardingNode;
import org.sirix.node.Kind;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.StructNode;
import org.sirix.settings.Fixed;

public class StructNodeDelegate
extends AbstractForwardingNode
implements StructNode {
    private long mFirstChild;
    private long mRightSibling;
    private long mLeftSibling;
    private long mChildCount;
    private long mDescendantCount;
    private final NodeDelegate mDelegate;

    public StructNodeDelegate(NodeDelegate del, long firstChild, long rightSib, long leftSib, @Nonnegative long childCount, @Nonnegative long descendantCount) {
        assert (childCount >= 0L) : "childCount must be >= 0!";
        assert (descendantCount >= 0L) : "descendantCount must be >= 0!";
        assert (del != null) : "del must not be null!";
        this.mDelegate = del;
        this.mFirstChild = firstChild;
        this.mRightSibling = rightSib;
        this.mLeftSibling = leftSib;
        this.mChildCount = childCount;
        this.mDescendantCount = descendantCount;
    }

    @Override
    public Kind getKind() {
        return this.mDelegate.getKind();
    }

    @Override
    public boolean hasFirstChild() {
        return this.mFirstChild != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasLeftSibling() {
        return this.mLeftSibling != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasRightSibling() {
        return this.mRightSibling != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getChildCount() {
        return this.mChildCount;
    }

    @Override
    public long getFirstChildKey() {
        return this.mFirstChild;
    }

    @Override
    public long getLeftSiblingKey() {
        return this.mLeftSibling;
    }

    @Override
    public long getRightSiblingKey() {
        return this.mRightSibling;
    }

    @Override
    public void setRightSiblingKey(long key) {
        this.mRightSibling = key;
    }

    @Override
    public void setLeftSiblingKey(long key) {
        this.mLeftSibling = key;
    }

    @Override
    public void setFirstChildKey(long key) {
        this.mFirstChild = key;
    }

    @Override
    public void decrementChildCount() {
        --this.mChildCount;
    }

    @Override
    public void incrementChildCount() {
        ++this.mChildCount;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mChildCount, this.mDelegate, this.mFirstChild, this.mLeftSibling, this.mRightSibling, this.mDescendantCount});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StructNodeDelegate)) {
            return false;
        }
        StructNodeDelegate other = (StructNodeDelegate)obj;
        return Objects.equal((Object)this.mChildCount, (Object)other.mChildCount) && Objects.equal((Object)this.mDelegate, (Object)other.mDelegate) && Objects.equal((Object)this.mFirstChild, (Object)other.mFirstChild) && Objects.equal((Object)this.mLeftSibling, (Object)other.mLeftSibling) && Objects.equal((Object)this.mRightSibling, (Object)other.mRightSibling) && Objects.equal((Object)this.mDescendantCount, (Object)other.mDescendantCount);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("first child", this.getFirstChildKey()).add("left sib", this.getLeftSiblingKey()).add("right sib", this.getRightSiblingKey()).add("child count", this.getChildCount()).add("descendant count", this.getDescendantCount()).add("node delegate", (Object)this.getNodeDelegate().toString()).toString();
    }

    @Override
    public long getDescendantCount() {
        return this.mDescendantCount;
    }

    @Override
    public void decrementDescendantCount() {
        --this.mDescendantCount;
    }

    @Override
    public void incrementDescendantCount() {
        ++this.mDescendantCount;
    }

    @Override
    public void setDescendantCount(@Nonnegative long descendantCount) {
        assert (descendantCount >= 0L) : "descendantCount must be >= 0!";
        this.mDescendantCount = descendantCount;
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        return this.mDelegate.isSameItem(other);
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mDelegate;
    }
}

