/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.sirix.api.visitor.JsonNodeVisitor;
import org.sirix.api.visitor.VisitResultType;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.interfaces.Node;
import org.sirix.settings.Fixed;
import org.sirix.utils.NamePageHash;

public class NodeDelegate
implements Node {
    private static final int TYPE_KEY = NamePageHash.generateHashForString("xs:untyped");
    private long mNodeKey;
    private long mParentKey;
    private long mHash;
    private int mTypeKey;
    private final long mRevision;
    private SirixDeweyID mID;

    public NodeDelegate(@Nonnegative long nodeKey, long parentKey, long hash, @Nonnegative long revision, SirixDeweyID deweyID) {
        assert (nodeKey >= 0L) : "nodeKey must be >= 0!";
        assert (parentKey >= Fixed.NULL_NODE_KEY.getStandardProperty());
        this.mNodeKey = nodeKey;
        this.mParentKey = parentKey;
        this.mHash = hash;
        this.mRevision = revision;
        this.mTypeKey = TYPE_KEY;
        this.mID = deweyID;
    }

    @Override
    public Kind getKind() {
        return Kind.UNKNOWN;
    }

    @Override
    public long getNodeKey() {
        return this.mNodeKey;
    }

    @Override
    public long getParentKey() {
        return this.mParentKey;
    }

    @Override
    public void setParentKey(long parentKey) {
        assert (parentKey >= Fixed.NULL_NODE_KEY.getStandardProperty());
        this.mParentKey = parentKey;
    }

    @Override
    public long getHash() {
        return this.mHash;
    }

    @Override
    public void setHash(long pHash) {
        this.mHash = pHash;
    }

    public VisitResultType acceptVisitor(XmlNodeVisitor pVisitor) {
        return VisitResultType.CONTINUE;
    }

    public VisitResultType acceptVisitor(JsonNodeVisitor pVisitor) {
        return VisitResultType.CONTINUE;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mNodeKey, this.mTypeKey, this.mHash, this.mParentKey});
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof NodeDelegate)) {
            return false;
        }
        NodeDelegate other = (NodeDelegate)otherObj;
        return Objects.equal((Object)this.mNodeKey, (Object)other.mNodeKey) && Objects.equal((Object)this.mTypeKey, (Object)other.mTypeKey) && Objects.equal((Object)this.mHash, (Object)other.mHash) && Objects.equal((Object)this.mParentKey, (Object)other.mParentKey);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node key", this.mNodeKey).add("parent key", this.mParentKey).add("type key", this.mTypeKey).add("hash", this.mHash).add("deweyID", (Object)this.mID).toString();
    }

    public int getTypeKey() {
        return this.mTypeKey;
    }

    @Override
    public void setTypeKey(int typeKey) {
        this.mTypeKey = typeKey;
    }

    @Override
    public boolean hasParent() {
        return this.mParentKey != Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean isSameItem(@Nullable Node other) {
        if (other == null) {
            return false;
        }
        return other.getNodeKey() == this.getNodeKey();
    }

    @Override
    public long getRevision() {
        return this.mRevision;
    }

    @Override
    public void setDeweyID(SirixDeweyID id) {
        this.mID = id;
    }

    public Optional<SirixDeweyID> getDeweyID() {
        return Optional.ofNullable(this.mID);
    }
}

